/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.skills;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.skills.PlayerSkillData;
import revive.mod.skills.SkillDataManager;
import revive.mod.skills.SkillManager;
import revive.mod.skills.SkillType;
import revive.mod.skills.SkillUpgrade;
import revive.mod.skills.SkillUpgrades;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001c\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lrevive/mod/skills/SkillNetworkHandler;", "", "<init>", "()V", "", "registerServer", "Lnet/minecraft/class_3222;", "player", "sendSkillDataToPlayer", "(Lnet/minecraft/class_3222;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lnet/minecraft/class_2960;", "SKILL_DATA_SYNC_ID", "Lnet/minecraft/class_2960;", "getSKILL_DATA_SYNC_ID", "()Lnet/minecraft/class_2960;", "SKILL_UNLOCK_REQUEST_ID", "getSKILL_UNLOCK_REQUEST_ID", "SkillDataSyncPayload", "SkillUnlockRequestPayload", "hardcore-mod"})
public final class SkillNetworkHandler {
    @NotNull
    public static final SkillNetworkHandler INSTANCE = new SkillNetworkHandler();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod-skills-network");
    @NotNull
    private static final class_2960 SKILL_DATA_SYNC_ID;
    @NotNull
    private static final class_2960 SKILL_UNLOCK_REQUEST_ID;

    private SkillNetworkHandler() {
    }

    @NotNull
    public final class_2960 getSKILL_DATA_SYNC_ID() {
        return SKILL_DATA_SYNC_ID;
    }

    @NotNull
    public final class_2960 getSKILL_UNLOCK_REQUEST_ID() {
        return SKILL_UNLOCK_REQUEST_ID;
    }

    public final void registerServer() {
        PayloadTypeRegistry.playS2C().register(SkillDataSyncPayload.Companion.getTYPE(), SkillDataSyncPayload.Companion.getCODEC());
        PayloadTypeRegistry.playC2S().register(SkillUnlockRequestPayload.Companion.getTYPE(), SkillUnlockRequestPayload.Companion.getCODEC());
        ServerPlayNetworking.registerGlobalReceiver(SkillUnlockRequestPayload.Companion.getTYPE(), SkillNetworkHandler::registerServer$lambda$0);
        logger.info("Server skill network handlers registered");
    }

    public final void sendSkillDataToPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        Map xpData = new LinkedHashMap();
        Map pointsData = new LinkedHashMap();
        for (Object skillType : SkillType.getEntries()) {
            xpData.put(((Enum)skillType).name(), skillData.getXp((SkillType)((Object)skillType)));
            pointsData.put(((Enum)skillType).name(), skillData.getSkillPoints((SkillType)((Object)skillType)));
        }
        Map upgradeData = new LinkedHashMap();
        for (SkillUpgrade upgrade : SkillUpgrades.INSTANCE.getAllUpgrades()) {
            int tier = skillData.getUpgradeTier(upgrade.getId());
            if (tier <= 0) continue;
            upgradeData.put(upgrade.getId(), tier);
        }
        SkillDataSyncPayload payload = new SkillDataSyncPayload(xpData, upgradeData, pointsData);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        logger.debug("Sent skill data to " + player.method_7334().name());
    }

    private static final void registerServer$lambda$0$0(class_3222 $player, SkillUnlockRequestPayload $payload) {
        boolean success = SkillManager.INSTANCE.tryUnlockUpgrade($player, $payload.getUpgradeId());
        if (success) {
            INSTANCE.sendSkillDataToPlayer($player);
        }
    }

    private static final void registerServer$lambda$0(SkillUnlockRequestPayload payload, ServerPlayNetworking.Context context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        class_3222 class_32222 = context.player();
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player(...)");
        class_3222 player = class_32222;
        context.server().execute(() -> SkillNetworkHandler.registerServer$lambda$0$0(player, payload));
    }

    static {
        class_2960 class_29602 = class_2960.method_60655((String)"hardcore-mod", (String)"skill_data_sync");
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"fromNamespaceAndPath(...)");
        SKILL_DATA_SYNC_ID = class_29602;
        class_2960 class_29603 = class_2960.method_60655((String)"hardcore-mod", (String)"skill_unlock_request");
        Intrinsics.checkNotNullExpressionValue((Object)class_29603, (String)"fromNamespaceAndPath(...)");
        SKILL_UNLOCK_REQUEST_ID = class_29603;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 BC\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000eJR\u0010\u0011\u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0018\u001a\u00020\u0004H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0011\u0010\u001a\u001a\u00020\u0003H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u001a\u0010\u001bR#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u000eR#\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001e\u0010\u000eR#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001f\u0010\u000e\u00a8\u0006!"}, d2={"Lrevive/mod/skills/SkillNetworkHandler$SkillDataSyncPayload;", "Lnet/minecraft/class_8710;", "", "", "", "xpData", "upgradeData", "pointsData", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "Lnet/minecraft/class_8710$class_9154;", "type", "()Lnet/minecraft/class_8710$class_9154;", "component1", "()Ljava/util/Map;", "component2", "component3", "copy", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)Lrevive/mod/skills/SkillNetworkHandler$SkillDataSyncPayload;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getXpData", "getUpgradeData", "getPointsData", "Companion", "hardcore-mod"})
    @SourceDebugExtension(value={"SMAP\nSkillNetworkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkillNetworkHandler.kt\nrevive/mod/skills/SkillNetworkHandler$SkillDataSyncPayload\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,148:1\n221#2,2:149\n221#2,2:151\n221#2,2:153\n*S KotlinDebug\n*F\n+ 1 SkillNetworkHandler.kt\nrevive/mod/skills/SkillNetworkHandler$SkillDataSyncPayload\n*L\n39#1:149,2\n44#1:151,2\n49#1:153,2\n*E\n"})
    public static final class SkillDataSyncPayload
    implements class_8710 {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, Integer> xpData;
        @NotNull
        private final Map<String, Integer> upgradeData;
        @NotNull
        private final Map<String, Integer> pointsData;
        @NotNull
        private static final class_8710.class_9154<SkillDataSyncPayload> TYPE = new class_8710.class_9154(INSTANCE.getSKILL_DATA_SYNC_ID());
        @NotNull
        private static final class_9139<class_2540, SkillDataSyncPayload> CODEC;

        public SkillDataSyncPayload(@NotNull Map<String, Integer> xpData, @NotNull Map<String, Integer> upgradeData, @NotNull Map<String, Integer> pointsData) {
            Intrinsics.checkNotNullParameter(xpData, (String)"xpData");
            Intrinsics.checkNotNullParameter(upgradeData, (String)"upgradeData");
            Intrinsics.checkNotNullParameter(pointsData, (String)"pointsData");
            this.xpData = xpData;
            this.upgradeData = upgradeData;
            this.pointsData = pointsData;
        }

        @NotNull
        public final Map<String, Integer> getXpData() {
            return this.xpData;
        }

        @NotNull
        public final Map<String, Integer> getUpgradeData() {
            return this.upgradeData;
        }

        @NotNull
        public final Map<String, Integer> getPointsData() {
            return this.pointsData;
        }

        @NotNull
        public class_8710.class_9154<SkillDataSyncPayload> method_56479() {
            return TYPE;
        }

        @NotNull
        public final Map<String, Integer> component1() {
            return this.xpData;
        }

        @NotNull
        public final Map<String, Integer> component2() {
            return this.upgradeData;
        }

        @NotNull
        public final Map<String, Integer> component3() {
            return this.pointsData;
        }

        @NotNull
        public final SkillDataSyncPayload copy(@NotNull Map<String, Integer> xpData, @NotNull Map<String, Integer> upgradeData, @NotNull Map<String, Integer> pointsData) {
            Intrinsics.checkNotNullParameter(xpData, (String)"xpData");
            Intrinsics.checkNotNullParameter(upgradeData, (String)"upgradeData");
            Intrinsics.checkNotNullParameter(pointsData, (String)"pointsData");
            return new SkillDataSyncPayload(xpData, upgradeData, pointsData);
        }

        public static /* synthetic */ SkillDataSyncPayload copy$default(SkillDataSyncPayload skillDataSyncPayload, Map map, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                map = skillDataSyncPayload.xpData;
            }
            if ((n & 2) != 0) {
                map2 = skillDataSyncPayload.upgradeData;
            }
            if ((n & 4) != 0) {
                map3 = skillDataSyncPayload.pointsData;
            }
            return skillDataSyncPayload.copy(map, map2, map3);
        }

        @NotNull
        public String toString() {
            return "SkillDataSyncPayload(xpData=" + this.xpData + ", upgradeData=" + this.upgradeData + ", pointsData=" + this.pointsData + ")";
        }

        public int hashCode() {
            int result = ((Object)this.xpData).hashCode();
            result = result * 31 + ((Object)this.upgradeData).hashCode();
            result = result * 31 + ((Object)this.pointsData).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SkillDataSyncPayload)) {
                return false;
            }
            SkillDataSyncPayload skillDataSyncPayload = (SkillDataSyncPayload)other;
            if (!Intrinsics.areEqual(this.xpData, skillDataSyncPayload.xpData)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.upgradeData, skillDataSyncPayload.upgradeData)) {
                return false;
            }
            return Intrinsics.areEqual(this.pointsData, skillDataSyncPayload.pointsData);
        }

        private static final void CODEC$lambda$0(class_2540 buf, SkillDataSyncPayload payload) {
            String skill;
            Map.Entry<String, Integer> entry;
            Map.Entry<String, Integer> element$iv;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            buf.method_53002(payload.xpData.size());
            Map<String, Integer> $this$forEach$iv = payload.xpData;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                skill = entry.getKey();
                int xp = ((Number)entry.getValue()).intValue();
                buf.method_10814(skill);
                buf.method_53002(xp);
            }
            buf.method_53002(payload.upgradeData.size());
            $this$forEach$iv = payload.upgradeData;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                String id = entry.getKey();
                int tier = ((Number)entry.getValue()).intValue();
                buf.method_10814(id);
                buf.method_53002(tier);
            }
            buf.method_53002(payload.pointsData.size());
            $this$forEach$iv = payload.pointsData;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                skill = entry.getKey();
                int points = ((Number)entry.getValue()).intValue();
                buf.method_10814(skill);
                buf.method_53002(points);
            }
        }

        private static final SkillDataSyncPayload CODEC$lambda$1(class_2540 buf) {
            int n;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int xpCount = buf.readInt();
            Map xpData = new LinkedHashMap();
            int n2 = 0;
            while (n2 < xpCount) {
                int it = n2++;
                n = 0;
                xpData.put(buf.method_19772(), buf.readInt());
            }
            int upgradeCount = buf.readInt();
            Map upgradeData = new LinkedHashMap();
            n = 0;
            while (n < upgradeCount) {
                int it = n++;
                boolean bl = false;
                upgradeData.put(buf.method_19772(), buf.readInt());
            }
            int pointsCount = buf.readInt();
            Map pointsData = new LinkedHashMap();
            int n3 = 0;
            while (n3 < pointsCount) {
                int it = n3++;
                boolean bl = false;
                pointsData.put(buf.method_19772(), buf.readInt());
            }
            return new SkillDataSyncPayload(xpData, upgradeData, pointsData);
        }

        static {
            class_9139 class_91392 = class_9139.method_56437(SkillDataSyncPayload::CODEC$lambda$0, SkillDataSyncPayload::CODEC$lambda$1);
            Intrinsics.checkNotNullExpressionValue((Object)class_91392, (String)"of(...)");
            CODEC = class_91392;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lrevive/mod/skills/SkillNetworkHandler$SkillDataSyncPayload$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_8710$class_9154;", "Lrevive/mod/skills/SkillNetworkHandler$SkillDataSyncPayload;", "TYPE", "Lnet/minecraft/class_8710$class_9154;", "getTYPE", "()Lnet/minecraft/class_8710$class_9154;", "Lnet/minecraft/class_9139;", "Lnet/minecraft/class_2540;", "CODEC", "Lnet/minecraft/class_9139;", "getCODEC", "()Lnet/minecraft/class_9139;", "hardcore-mod"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final class_8710.class_9154<SkillDataSyncPayload> getTYPE() {
                return TYPE;
            }

            @NotNull
            public final class_9139<class_2540, SkillDataSyncPayload> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0013\u001a\u00020\u0012H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0015\u001a\u00020\u0002H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\n\u00a8\u0006\u0019"}, d2={"Lrevive/mod/skills/SkillNetworkHandler$SkillUnlockRequestPayload;", "Lnet/minecraft/class_8710;", "", "upgradeId", "<init>", "(Ljava/lang/String;)V", "Lnet/minecraft/class_8710$class_9154;", "type", "()Lnet/minecraft/class_8710$class_9154;", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Lrevive/mod/skills/SkillNetworkHandler$SkillUnlockRequestPayload;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getUpgradeId", "Companion", "hardcore-mod"})
    public static final class SkillUnlockRequestPayload
    implements class_8710 {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String upgradeId;
        @NotNull
        private static final class_8710.class_9154<SkillUnlockRequestPayload> TYPE = new class_8710.class_9154(INSTANCE.getSKILL_UNLOCK_REQUEST_ID());
        @NotNull
        private static final class_9139<class_2540, SkillUnlockRequestPayload> CODEC;

        public SkillUnlockRequestPayload(@NotNull String upgradeId) {
            Intrinsics.checkNotNullParameter((Object)upgradeId, (String)"upgradeId");
            this.upgradeId = upgradeId;
        }

        @NotNull
        public final String getUpgradeId() {
            return this.upgradeId;
        }

        @NotNull
        public class_8710.class_9154<SkillUnlockRequestPayload> method_56479() {
            return TYPE;
        }

        @NotNull
        public final String component1() {
            return this.upgradeId;
        }

        @NotNull
        public final SkillUnlockRequestPayload copy(@NotNull String upgradeId) {
            Intrinsics.checkNotNullParameter((Object)upgradeId, (String)"upgradeId");
            return new SkillUnlockRequestPayload(upgradeId);
        }

        public static /* synthetic */ SkillUnlockRequestPayload copy$default(SkillUnlockRequestPayload skillUnlockRequestPayload, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = skillUnlockRequestPayload.upgradeId;
            }
            return skillUnlockRequestPayload.copy(string);
        }

        @NotNull
        public String toString() {
            return "SkillUnlockRequestPayload(upgradeId=" + this.upgradeId + ")";
        }

        public int hashCode() {
            return this.upgradeId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SkillUnlockRequestPayload)) {
                return false;
            }
            SkillUnlockRequestPayload skillUnlockRequestPayload = (SkillUnlockRequestPayload)other;
            return Intrinsics.areEqual((Object)this.upgradeId, (Object)skillUnlockRequestPayload.upgradeId);
        }

        private static final void CODEC$lambda$0(class_2540 buf, SkillUnlockRequestPayload payload) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            buf.method_10814(payload.upgradeId);
        }

        private static final SkillUnlockRequestPayload CODEC$lambda$1(class_2540 buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            String string = buf.method_19772();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUtf(...)");
            return new SkillUnlockRequestPayload(string);
        }

        static {
            class_9139 class_91392 = class_9139.method_56437(SkillUnlockRequestPayload::CODEC$lambda$0, SkillUnlockRequestPayload::CODEC$lambda$1);
            Intrinsics.checkNotNullExpressionValue((Object)class_91392, (String)"of(...)");
            CODEC = class_91392;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lrevive/mod/skills/SkillNetworkHandler$SkillUnlockRequestPayload$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_8710$class_9154;", "Lrevive/mod/skills/SkillNetworkHandler$SkillUnlockRequestPayload;", "TYPE", "Lnet/minecraft/class_8710$class_9154;", "getTYPE", "()Lnet/minecraft/class_8710$class_9154;", "Lnet/minecraft/class_9139;", "Lnet/minecraft/class_2540;", "CODEC", "Lnet/minecraft/class_9139;", "getCODEC", "()Lnet/minecraft/class_9139;", "hardcore-mod"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final class_8710.class_9154<SkillUnlockRequestPayload> getTYPE() {
                return TYPE;
            }

            @NotNull
            public final class_9139<class_2540, SkillUnlockRequestPayload> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

