/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.skills;

import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.skills.PlayerSkillData;
import revive.mod.skills.SkillDataManager;
import revive.mod.skills.SkillType;
import revive.mod.skills.SkillUpgrade;
import revive.mod.skills.SkillUpgrades;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010!J\u0015\u0010#\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010!J\u0015\u0010$\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010!J\u0015\u0010%\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b%\u0010!J\u0015\u0010&\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010!J\u0015\u0010'\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b'\u0010!J\u0015\u0010(\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b(\u0010!J\u0015\u0010)\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b)\u0010!J\u0015\u0010*\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b*\u0010!J\u0015\u0010+\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b+\u0010!J\u0015\u0010,\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b,\u0010!J\u0015\u0010-\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b/\u00100R\u001c\u00103\u001a\n 2*\u0004\u0018\u000101018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R%\u00107\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b6\u0012\u0004\u0012\u00020\u0018058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R%\u00109\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b6\u0012\u0004\u0012\u00020\u0018058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00108R%\u0010:\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b6\u0012\u0004\u0012\u00020\u0018058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00108R%\u0010;\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b6\u0012\u0004\u0012\u00020\u0018058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00108R\u0014\u0010<\u001a\u00020\u00188\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020\u00188\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b>\u0010=R\u0014\u0010?\u001a\u00020\u00188\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b?\u0010=R\u0014\u0010@\u001a\u00020\u00188\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b@\u0010=\u00a8\u0006A"}, d2={"Lrevive/mod/skills/SkillManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_2248;", "block", "", "onBlockBreak", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2248;)V", "", "damage", "onDamageDealt", "(Lnet/minecraft/class_3222;F)V", "", "isTreasure", "isJunk", "onFishCaught", "(Lnet/minecraft/class_3222;ZZ)V", "Lrevive/mod/skills/PlayerSkillData;", "skillData", "Lrevive/mod/skills/SkillType;", "skillType", "", "amount", "awardXp", "(Lnet/minecraft/class_3222;Lrevive/mod/skills/PlayerSkillData;Lrevive/mod/skills/SkillType;I)V", "", "upgradeId", "tryUnlockUpgrade", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "getMiningSpeedBonus", "(Lnet/minecraft/class_3222;)F", "getWoodcuttingSpeedBonus", "getExcavationSpeedBonus", "getDamageBonus", "getDefenseBonus", "getCriticalChanceBonus", "getLifestealBonus", "getDoubleOreChance", "getExtraLogChance", "getFishingSpeedBonus", "getTreasureHunterBonus", "getHarvestBonus", "isSkillBlock", "(Lnet/minecraft/class_2248;)Z", "getSkillTypeForBlock", "(Lnet/minecraft/class_2248;)Lrevive/mod/skills/SkillType;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "MINING_XP", "Ljava/util/Map;", "WOODCUTTING_XP", "EXCAVATION_XP", "FARMING_XP", "COMBAT_XP_PER_DAMAGE", "I", "FISHING_XP_FISH", "FISHING_XP_TREASURE", "FISHING_XP_JUNK", "hardcore-mod"})
public final class SkillManager {
    @NotNull
    public static final SkillManager INSTANCE = new SkillManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod-skills");
    @NotNull
    private static final Map<class_2248, Integer> MINING_XP;
    @NotNull
    private static final Map<class_2248, Integer> WOODCUTTING_XP;
    @NotNull
    private static final Map<class_2248, Integer> EXCAVATION_XP;
    @NotNull
    private static final Map<class_2248, Integer> FARMING_XP;
    public static final int COMBAT_XP_PER_DAMAGE = 2;
    public static final int FISHING_XP_FISH = 15;
    public static final int FISHING_XP_TREASURE = 50;
    public static final int FISHING_XP_JUNK = 5;

    private SkillManager() {
    }

    public final void onBlockBreak(@NotNull class_3222 player, @NotNull class_2248 block) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        if (MINING_XP.containsKey(block)) {
            Integer n = MINING_XP.get(block);
            Intrinsics.checkNotNull((Object)n);
            pair = TuplesKt.to((Object)((Object)SkillType.MINING), (Object)n);
        } else if (WOODCUTTING_XP.containsKey(block)) {
            Integer n = WOODCUTTING_XP.get(block);
            Intrinsics.checkNotNull((Object)n);
            pair = TuplesKt.to((Object)((Object)SkillType.WOODCUTTING), (Object)n);
        } else if (EXCAVATION_XP.containsKey(block)) {
            Integer n = EXCAVATION_XP.get(block);
            Intrinsics.checkNotNull((Object)n);
            pair = TuplesKt.to((Object)((Object)SkillType.EXCAVATION), (Object)n);
        } else if (FARMING_XP.containsKey(block)) {
            Integer n = FARMING_XP.get(block);
            Intrinsics.checkNotNull((Object)n);
            pair = TuplesKt.to((Object)((Object)SkillType.FARMING), (Object)n);
        } else {
            return;
        }
        Pair pair2 = pair;
        SkillType skillType = (SkillType)((Object)pair2.component1());
        int xp = ((Number)pair2.component2()).intValue();
        this.awardXp(player, skillData, skillType, xp);
    }

    public final void onDamageDealt(@NotNull class_3222 player, float damage) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        int xp = RangesKt.coerceAtLeast((int)((int)(damage * (float)2)), (int)1);
        this.awardXp(player, skillData, SkillType.COMBAT, xp);
    }

    public final void onFishCaught(@NotNull class_3222 player, boolean isTreasure, boolean isJunk) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        int xp = isTreasure ? 50 : (isJunk ? 5 : 15);
        this.awardXp(player, skillData, SkillType.FISHING, xp);
    }

    private final void awardXp(class_3222 player, PlayerSkillData skillData, SkillType skillType, int amount) {
        int oldLevel = skillData.getLevel(skillType);
        int levelsGained = skillData.addXp(skillType, amount);
        if (amount >= 5) {
            player.method_7353((class_2561)class_2561.method_43470((String)(skillType.getColor() + "+" + amount + " " + skillType.getDisplayName() + " XP")), true);
        }
        if (levelsGained > 0) {
            int newLevel = skillData.getLevel(skillType);
            player.method_64398((class_2561)class_2561.method_43470((String)""));
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l=== LEVEL UP! ==="));
            player.method_64398((class_2561)class_2561.method_43470((String)(skillType.getColor() + skillType.getDisplayName() + " \u00a7fis now level \u00a7e" + newLevel)));
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7a+" + levelsGained + " Skill Point(s)!")));
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7f/skills\u00a77 to spend points."));
            player.method_64398((class_2561)class_2561.method_43470((String)""));
            player.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)class_3417.field_14709), class_3419.field_15248, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f, player.method_51469().field_9229.method_43055()));
            logger.info(player.method_7334().name() + " leveled up " + skillType.name() + " to level " + newLevel);
        }
    }

    public final boolean tryUnlockUpgrade(@NotNull class_3222 player, @NotNull String upgradeId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)upgradeId, (String)"upgradeId");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        SkillUpgrade skillUpgrade = SkillUpgrades.INSTANCE.getUpgradeById(upgradeId);
        if (skillUpgrade == null) {
            return false;
        }
        SkillUpgrade upgrade = skillUpgrade;
        if (skillData.unlockUpgrade(upgrade)) {
            int newTier = skillData.getUpgradeTier(upgradeId);
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7lUpgrade Unlocked!"));
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7e" + upgrade.getName() + " \u00a77- Tier " + newTier + "/" + upgrade.getMaxTier())));
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a77" + upgrade.getDescriptionWithEffect(newTier))));
            player.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)class_3417.field_15119), class_3419.field_15248, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.2f, player.method_51469().field_9229.method_43055()));
            logger.info(player.method_7334().name() + " unlocked " + upgrade.getName() + " tier " + newTier);
            return true;
        }
        return false;
    }

    public final float getMiningSpeedBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("mining_speed");
    }

    public final float getWoodcuttingSpeedBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("chopping_speed");
    }

    public final float getExcavationSpeedBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("dig_speed");
    }

    public final float getDamageBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("damage_boost");
    }

    public final float getDefenseBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("defense");
    }

    public final float getCriticalChanceBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("critical_strike");
    }

    public final float getLifestealBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("lifesteal");
    }

    public final float getDoubleOreChance(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("double_ore");
    }

    public final float getExtraLogChance(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("extra_logs");
    }

    public final float getFishingSpeedBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("fishing_speed");
    }

    public final float getTreasureHunterBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("treasure_hunter");
    }

    public final float getHarvestBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerSkillData playerSkillData = SkillDataManager.INSTANCE.getPlayerData(uUID);
        if (playerSkillData == null) {
            return 0.0f;
        }
        PlayerSkillData skillData = playerSkillData;
        return skillData.getUpgradeEffect("harvest_bonus");
    }

    public final boolean isSkillBlock(@NotNull class_2248 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return MINING_XP.containsKey(block) || WOODCUTTING_XP.containsKey(block) || EXCAVATION_XP.containsKey(block) || FARMING_XP.containsKey(block);
    }

    @Nullable
    public final SkillType getSkillTypeForBlock(@NotNull class_2248 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return MINING_XP.containsKey(block) ? SkillType.MINING : (WOODCUTTING_XP.containsKey(block) ? SkillType.WOODCUTTING : (EXCAVATION_XP.containsKey(block) ? SkillType.EXCAVATION : (FARMING_XP.containsKey(block) ? SkillType.FARMING : null)));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)class_2246.field_10340, (Object)1), TuplesKt.to((Object)class_2246.field_10445, (Object)1), TuplesKt.to((Object)class_2246.field_28888, (Object)2), TuplesKt.to((Object)class_2246.field_29031, (Object)2), TuplesKt.to((Object)class_2246.field_10418, (Object)5), TuplesKt.to((Object)class_2246.field_29219, (Object)6), TuplesKt.to((Object)class_2246.field_10212, (Object)8), TuplesKt.to((Object)class_2246.field_29027, (Object)10), TuplesKt.to((Object)class_2246.field_27120, (Object)6), TuplesKt.to((Object)class_2246.field_29221, (Object)7), TuplesKt.to((Object)class_2246.field_10571, (Object)12), TuplesKt.to((Object)class_2246.field_29026, (Object)15), TuplesKt.to((Object)class_2246.field_10080, (Object)10), TuplesKt.to((Object)class_2246.field_29030, (Object)12), TuplesKt.to((Object)class_2246.field_10090, (Object)15), TuplesKt.to((Object)class_2246.field_29028, (Object)18), TuplesKt.to((Object)class_2246.field_10442, (Object)25), TuplesKt.to((Object)class_2246.field_29029, (Object)30), TuplesKt.to((Object)class_2246.field_10013, (Object)30), TuplesKt.to((Object)class_2246.field_29220, (Object)35), TuplesKt.to((Object)class_2246.field_10213, (Object)8), TuplesKt.to((Object)class_2246.field_23077, (Object)10), TuplesKt.to((Object)class_2246.field_22109, (Object)50), TuplesKt.to((Object)class_2246.field_10540, (Object)15), TuplesKt.to((Object)class_2246.field_22423, (Object)20), TuplesKt.to((Object)class_2246.field_27159, (Object)5), TuplesKt.to((Object)class_2246.field_27160, (Object)10)};
        MINING_XP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)class_2246.field_10431, (Object)5), TuplesKt.to((Object)class_2246.field_10037, (Object)5), TuplesKt.to((Object)class_2246.field_10511, (Object)5), TuplesKt.to((Object)class_2246.field_10306, (Object)6), TuplesKt.to((Object)class_2246.field_10533, (Object)6), TuplesKt.to((Object)class_2246.field_10010, (Object)7), TuplesKt.to((Object)class_2246.field_37545, (Object)6), TuplesKt.to((Object)class_2246.field_42729, (Object)7), TuplesKt.to((Object)class_2246.field_22118, (Object)8), TuplesKt.to((Object)class_2246.field_22111, (Object)8), TuplesKt.to((Object)class_2246.field_10519, (Object)3), TuplesKt.to((Object)class_2246.field_10436, (Object)3), TuplesKt.to((Object)class_2246.field_10366, (Object)3), TuplesKt.to((Object)class_2246.field_10254, (Object)3), TuplesKt.to((Object)class_2246.field_10622, (Object)3), TuplesKt.to((Object)class_2246.field_10244, (Object)4), TuplesKt.to((Object)class_2246.field_37548, (Object)3), TuplesKt.to((Object)class_2246.field_42732, (Object)4), TuplesKt.to((Object)class_2246.field_22119, (Object)4), TuplesKt.to((Object)class_2246.field_22112, (Object)4)};
        WOODCUTTING_XP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)class_2246.field_10566, (Object)1), TuplesKt.to((Object)class_2246.field_10219, (Object)2), TuplesKt.to((Object)class_2246.field_10253, (Object)1), TuplesKt.to((Object)class_2246.field_10520, (Object)2), TuplesKt.to((Object)class_2246.field_10402, (Object)3), TuplesKt.to((Object)class_2246.field_10102, (Object)1), TuplesKt.to((Object)class_2246.field_10534, (Object)2), TuplesKt.to((Object)class_2246.field_10255, (Object)2), TuplesKt.to((Object)class_2246.field_10460, (Object)4), TuplesKt.to((Object)class_2246.field_10114, (Object)3), TuplesKt.to((Object)class_2246.field_22090, (Object)3), TuplesKt.to((Object)class_2246.field_37576, (Object)2), TuplesKt.to((Object)class_2246.field_37547, (Object)3), TuplesKt.to((Object)class_2246.field_10491, (Object)2), TuplesKt.to((Object)class_2246.field_27879, (Object)1)};
        EXCAVATION_XP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)class_2246.field_10293, (Object)5), TuplesKt.to((Object)class_2246.field_10609, (Object)5), TuplesKt.to((Object)class_2246.field_10247, (Object)5), TuplesKt.to((Object)class_2246.field_10341, (Object)6), TuplesKt.to((Object)class_2246.field_46283, (Object)8), TuplesKt.to((Object)class_2246.field_46282, (Object)8), TuplesKt.to((Object)class_2246.field_10302, (Object)7), TuplesKt.to((Object)class_2246.field_9974, (Object)10), TuplesKt.to((Object)class_2246.field_10424, (Object)3), TuplesKt.to((Object)class_2246.field_10029, (Object)3), TuplesKt.to((Object)class_2246.field_10211, (Object)1), TuplesKt.to((Object)class_2246.field_16999, (Object)4)};
        FARMING_XP = MapsKt.mapOf((Pair[])pairArray);
    }
}

