/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.skills;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revive.mod.skills.ClientSkillData;
import revive.mod.skills.SkillType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006JI\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0003R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lrevive/mod/skills/ClientSkillCache;", "", "<init>", "()V", "Lrevive/mod/skills/ClientSkillData;", "getSkillData", "()Lrevive/mod/skills/ClientSkillData;", "", "Lrevive/mod/skills/SkillType;", "", "xpData", "", "upgradeData", "pointsData", "", "updateFromServer", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "clear", "skillData", "Lrevive/mod/skills/ClientSkillData;", "hardcore-mod_client"})
@Environment(value=EnvType.CLIENT)
public final class ClientSkillCache {
    @NotNull
    public static final ClientSkillCache INSTANCE = new ClientSkillCache();
    @Nullable
    private static ClientSkillData skillData;

    private ClientSkillCache() {
    }

    @NotNull
    public final ClientSkillData getSkillData() {
        if (skillData == null) {
            skillData = new ClientSkillData();
        }
        ClientSkillData clientSkillData = skillData;
        Intrinsics.checkNotNull((Object)clientSkillData);
        return clientSkillData;
    }

    public final void updateFromServer(@NotNull Map<SkillType, Integer> xpData, @NotNull Map<String, Integer> upgradeData, @NotNull Map<SkillType, Integer> pointsData) {
        SkillType skill;
        Intrinsics.checkNotNullParameter(xpData, (String)"xpData");
        Intrinsics.checkNotNullParameter(upgradeData, (String)"upgradeData");
        Intrinsics.checkNotNullParameter(pointsData, (String)"pointsData");
        ClientSkillData data = this.getSkillData();
        for (Map.Entry<SkillType, Integer> entry : xpData.entrySet()) {
            skill = entry.getKey();
            int xp = ((Number)entry.getValue()).intValue();
            data.setXp(skill, xp);
        }
        for (Map.Entry<Object, Integer> entry : upgradeData.entrySet()) {
            String upgradeId = (String)entry.getKey();
            int tier = ((Number)entry.getValue()).intValue();
            data.setUpgradeTier(upgradeId, tier);
        }
        for (Map.Entry<Object, Integer> entry : pointsData.entrySet()) {
            skill = (SkillType)((Object)entry.getKey());
            int points = ((Number)entry.getValue()).intValue();
            data.setSkillPoints(skill, points);
        }
    }

    public final void clear() {
        skillData = null;
    }
}

