/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.GameSessionManager;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.PlayerStatus;
import revive.mod.ReviveTask;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u001c\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lrevive/mod/NetworkHandler;", "", "<init>", "()V", "", "registerServer", "Lnet/minecraft/class_3222;", "player", "sendStatusUpdate", "(Lnet/minecraft/class_3222;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "broadcastStatusUpdates", "(Lnet/minecraft/server/MinecraftServer;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lnet/minecraft/class_2960;", "STATUS_SYNC_ID", "Lnet/minecraft/class_2960;", "getSTATUS_SYNC_ID", "()Lnet/minecraft/class_2960;", "StatusSyncPayload", "hardcore-mod"})
@SourceDebugExtension(value={"SMAP\nNetworkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkHandler.kt\nrevive/mod/NetworkHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1915#2,2:107\n*S KotlinDebug\n*F\n+ 1 NetworkHandler.kt\nrevive/mod/NetworkHandler\n*L\n101#1:107,2\n*E\n"})
public final class NetworkHandler {
    @NotNull
    public static final NetworkHandler INSTANCE = new NetworkHandler();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    private static final class_2960 STATUS_SYNC_ID;

    private NetworkHandler() {
    }

    @NotNull
    public final class_2960 getSTATUS_SYNC_ID() {
        return STATUS_SYNC_ID;
    }

    public final void registerServer() {
        PayloadTypeRegistry.playS2C().register(StatusSyncPayload.Companion.getTYPE(), StatusSyncPayload.Companion.getSTREAM_CODEC());
        logger.info("Server network handlers registered");
    }

    public final void sendStatusUpdate(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ReviveTask task = PlayerStateManager.INSTANCE.getReviveTask(uUID);
        int statusInt = switch (WhenMappings.$EnumSwitchMapping$0[state.getStatus().ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            default -> throw new NoWhenBranchMatchedException();
        };
        ReviveTask reviveTask = task;
        ReviveTask reviveTask2 = task;
        StatusSyncPayload payload = new StatusSyncPayload(statusInt, state.getDeathCount(), reviveTask != null ? reviveTask.getParkourCompleted() : false, reviveTask2 != null ? reviveTask2.getCraftingCompleted() : false, GameSessionManager.INSTANCE.isGameActive(), GameSessionManager.INSTANCE.isGamePaused(), GameSessionManager.INSTANCE.getElapsedTimeMs());
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public final void broadcastStatusUpdates(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            INSTANCE.sendStatusUpdate(player);
        }
    }

    static {
        class_2960 class_29602 = class_2960.method_60655((String)"hardcore-mod", (String)"status_sync");
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"fromNamespaceAndPath(...)");
        STATUS_SYNC_ID = class_29602;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0010\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0015J\u0010\u0010\u0019\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJV\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001f\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u001f\u0010 J\u0011\u0010!\u001a\u00020\u0002H\u00d6\u0081\u0004\u00a2\u0006\u0004\b!\u0010\u0012J\u0011\u0010#\u001a\u00020\"H\u00d6\u0081\u0004\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b&\u0010\u0012R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010%\u001a\u0004\b'\u0010\u0012R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010(\u001a\u0004\b)\u0010\u0015R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010(\u001a\u0004\b*\u0010\u0015R\u0017\u0010\b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u0010(\u001a\u0004\b+\u0010\u0015R\u0017\u0010\t\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010(\u001a\u0004\b,\u0010\u0015R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010-\u001a\u0004\b.\u0010\u001a\u00a8\u00060"}, d2={"Lrevive/mod/NetworkHandler$StatusSyncPayload;", "Lnet/minecraft/class_8710;", "", "status", "deathCount", "", "parkourCompleted", "craftingCompleted", "gameActive", "gamePaused", "", "elapsedTimeMs", "<init>", "(IIZZZZJ)V", "Lnet/minecraft/class_8710$class_9154;", "type", "()Lnet/minecraft/class_8710$class_9154;", "component1", "()I", "component2", "component3", "()Z", "component4", "component5", "component6", "component7", "()J", "copy", "(IIZZZZJ)Lrevive/mod/NetworkHandler$StatusSyncPayload;", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getStatus", "getDeathCount", "Z", "getParkourCompleted", "getCraftingCompleted", "getGameActive", "getGamePaused", "J", "getElapsedTimeMs", "Companion", "hardcore-mod"})
    public static final class StatusSyncPayload
    implements class_8710 {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int status;
        private final int deathCount;
        private final boolean parkourCompleted;
        private final boolean craftingCompleted;
        private final boolean gameActive;
        private final boolean gamePaused;
        private final long elapsedTimeMs;
        @NotNull
        private static final class_8710.class_9154<StatusSyncPayload> TYPE = new class_8710.class_9154(INSTANCE.getSTATUS_SYNC_ID());
        @NotNull
        private static final class_9139<class_2540, StatusSyncPayload> STREAM_CODEC;

        public StatusSyncPayload(int status, int deathCount, boolean parkourCompleted, boolean craftingCompleted, boolean gameActive, boolean gamePaused, long elapsedTimeMs) {
            this.status = status;
            this.deathCount = deathCount;
            this.parkourCompleted = parkourCompleted;
            this.craftingCompleted = craftingCompleted;
            this.gameActive = gameActive;
            this.gamePaused = gamePaused;
            this.elapsedTimeMs = elapsedTimeMs;
        }

        public final int getStatus() {
            return this.status;
        }

        public final int getDeathCount() {
            return this.deathCount;
        }

        public final boolean getParkourCompleted() {
            return this.parkourCompleted;
        }

        public final boolean getCraftingCompleted() {
            return this.craftingCompleted;
        }

        public final boolean getGameActive() {
            return this.gameActive;
        }

        public final boolean getGamePaused() {
            return this.gamePaused;
        }

        public final long getElapsedTimeMs() {
            return this.elapsedTimeMs;
        }

        @NotNull
        public class_8710.class_9154<StatusSyncPayload> method_56479() {
            return TYPE;
        }

        public final int component1() {
            return this.status;
        }

        public final int component2() {
            return this.deathCount;
        }

        public final boolean component3() {
            return this.parkourCompleted;
        }

        public final boolean component4() {
            return this.craftingCompleted;
        }

        public final boolean component5() {
            return this.gameActive;
        }

        public final boolean component6() {
            return this.gamePaused;
        }

        public final long component7() {
            return this.elapsedTimeMs;
        }

        @NotNull
        public final StatusSyncPayload copy(int status, int deathCount, boolean parkourCompleted, boolean craftingCompleted, boolean gameActive, boolean gamePaused, long elapsedTimeMs) {
            return new StatusSyncPayload(status, deathCount, parkourCompleted, craftingCompleted, gameActive, gamePaused, elapsedTimeMs);
        }

        public static /* synthetic */ StatusSyncPayload copy$default(StatusSyncPayload statusSyncPayload, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = statusSyncPayload.status;
            }
            if ((n3 & 2) != 0) {
                n2 = statusSyncPayload.deathCount;
            }
            if ((n3 & 4) != 0) {
                bl = statusSyncPayload.parkourCompleted;
            }
            if ((n3 & 8) != 0) {
                bl2 = statusSyncPayload.craftingCompleted;
            }
            if ((n3 & 0x10) != 0) {
                bl3 = statusSyncPayload.gameActive;
            }
            if ((n3 & 0x20) != 0) {
                bl4 = statusSyncPayload.gamePaused;
            }
            if ((n3 & 0x40) != 0) {
                l = statusSyncPayload.elapsedTimeMs;
            }
            return statusSyncPayload.copy(n, n2, bl, bl2, bl3, bl4, l);
        }

        @NotNull
        public String toString() {
            return "StatusSyncPayload(status=" + this.status + ", deathCount=" + this.deathCount + ", parkourCompleted=" + this.parkourCompleted + ", craftingCompleted=" + this.craftingCompleted + ", gameActive=" + this.gameActive + ", gamePaused=" + this.gamePaused + ", elapsedTimeMs=" + this.elapsedTimeMs + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.status);
            result = result * 31 + Integer.hashCode(this.deathCount);
            result = result * 31 + Boolean.hashCode(this.parkourCompleted);
            result = result * 31 + Boolean.hashCode(this.craftingCompleted);
            result = result * 31 + Boolean.hashCode(this.gameActive);
            result = result * 31 + Boolean.hashCode(this.gamePaused);
            result = result * 31 + Long.hashCode(this.elapsedTimeMs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatusSyncPayload)) {
                return false;
            }
            StatusSyncPayload statusSyncPayload = (StatusSyncPayload)other;
            if (this.status != statusSyncPayload.status) {
                return false;
            }
            if (this.deathCount != statusSyncPayload.deathCount) {
                return false;
            }
            if (this.parkourCompleted != statusSyncPayload.parkourCompleted) {
                return false;
            }
            if (this.craftingCompleted != statusSyncPayload.craftingCompleted) {
                return false;
            }
            if (this.gameActive != statusSyncPayload.gameActive) {
                return false;
            }
            if (this.gamePaused != statusSyncPayload.gamePaused) {
                return false;
            }
            return this.elapsedTimeMs == statusSyncPayload.elapsedTimeMs;
        }

        private static final void STREAM_CODEC$lambda$0(class_2540 buf, StatusSyncPayload payload) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            buf.method_53002(payload.status);
            buf.method_53002(payload.deathCount);
            buf.method_52964(payload.parkourCompleted);
            buf.method_52964(payload.craftingCompleted);
            buf.method_52964(payload.gameActive);
            buf.method_52964(payload.gamePaused);
            buf.method_52974(payload.elapsedTimeMs);
        }

        private static final StatusSyncPayload STREAM_CODEC$lambda$1(class_2540 buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return new StatusSyncPayload(buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readLong());
        }

        static {
            class_9139 class_91392 = class_9139.method_56437(StatusSyncPayload::STREAM_CODEC$lambda$0, StatusSyncPayload::STREAM_CODEC$lambda$1);
            Intrinsics.checkNotNullExpressionValue((Object)class_91392, (String)"of(...)");
            STREAM_CODEC = class_91392;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lrevive/mod/NetworkHandler$StatusSyncPayload$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_8710$class_9154;", "Lrevive/mod/NetworkHandler$StatusSyncPayload;", "TYPE", "Lnet/minecraft/class_8710$class_9154;", "getTYPE", "()Lnet/minecraft/class_8710$class_9154;", "Lnet/minecraft/class_9139;", "Lnet/minecraft/class_2540;", "STREAM_CODEC", "Lnet/minecraft/class_9139;", "getSTREAM_CODEC", "()Lnet/minecraft/class_9139;", "hardcore-mod"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final class_8710.class_9154<StatusSyncPayload> getTYPE() {
                return TYPE;
            }

            @NotNull
            public final class_9139<class_2540, StatusSyncPayload> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerStatus.values().length];
            try {
                nArray[PlayerStatus.ALIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerStatus.IN_PURGATORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerStatus.SPECTATOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

