/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.DeathHandler;
import revive.mod.DimensionManager;
import revive.mod.GameSessionManager;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.discord.DiscordNotifier;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0019\u0010\u0014J\u0015\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001a\u0010\u0017J\u0015\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001b\u0010\u0017J\u0015\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001c\u0010\u0017J\u0015\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001d\u0010\u0014J\u0015\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\t\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\t\u00a2\u0006\u0004\b!\u0010 J\r\u0010\"\u001a\u00020\t\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020\u0015\u00a2\u0006\u0004\b$\u0010\u0003J\r\u0010%\u001a\u00020\t\u00a2\u0006\u0004\b%\u0010#J\u0015\u0010'\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0004\u00a2\u0006\u0004\b'\u0010(R\u001c\u0010+\u001a\n **\u0004\u0018\u00010)0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020-8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001d\u00102\u001a\b\u0012\u0004\u0012\u000201008\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00107R\u0016\u00109\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lrevive/mod/ChallengeManager;", "", "<init>", "()V", "", "isChallengeSetup", "()Z", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_2338;", "spawnPoint", "completionPoint", "setupChallenge", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;)Z", "Lnet/minecraft/class_3218;", "getChallengeLevel", "(Lnet/minecraft/server/MinecraftServer;)Lnet/minecraft/class_3218;", "Lnet/minecraft/class_3222;", "player", "canDoChallenge", "(Lnet/minecraft/class_3222;)Z", "", "showChallengeQuestion", "(Lnet/minecraft/class_3222;)V", "acceptChallenge", "declineChallenge", "teleportToChallenge", "onChallengeComplete", "onChallengeFailure", "isInChallengeDimension", "pos", "setSpawnPoint", "(Lnet/minecraft/class_2338;)V", "setCompletionPoint", "getCompletionPoint", "()Lnet/minecraft/class_2338;", "reset", "getSpawnPoint", "setup", "setChallengeSetup", "(Z)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "MOD_ID", "Ljava/lang/String;", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_1937;", "CHALLENGE_DIMENSION_KEY", "Lnet/minecraft/class_5321;", "getCHALLENGE_DIMENSION_KEY", "()Lnet/minecraft/class_5321;", "challengeSpawnPoint", "Lnet/minecraft/class_2338;", "challengeCompletionPoint", "challengeSetup", "Z", "hardcore-mod"})
public final class ChallengeManager {
    @NotNull
    public static final ChallengeManager INSTANCE = new ChallengeManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    public static final String MOD_ID = "hardcore-mod";
    @NotNull
    private static final class_5321<class_1937> CHALLENGE_DIMENSION_KEY;
    @NotNull
    private static class_2338 challengeSpawnPoint;
    @NotNull
    private static class_2338 challengeCompletionPoint;
    private static boolean challengeSetup;

    private ChallengeManager() {
    }

    @NotNull
    public final class_5321<class_1937> getCHALLENGE_DIMENSION_KEY() {
        return CHALLENGE_DIMENSION_KEY;
    }

    public final boolean isChallengeSetup() {
        return challengeSetup;
    }

    public final boolean setupChallenge(@NotNull MinecraftServer server, @NotNull class_2338 spawnPoint, @NotNull class_2338 completionPoint) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)spawnPoint, (String)"spawnPoint");
        Intrinsics.checkNotNullParameter((Object)completionPoint, (String)"completionPoint");
        class_3218 challengeLevel = this.getChallengeLevel(server);
        if (challengeLevel == null) {
            logger.error("Challenge dimension not found!");
            return false;
        }
        challengeSpawnPoint = spawnPoint;
        challengeCompletionPoint = completionPoint;
        challengeSetup = true;
        logger.info("Challenge world setup complete! Spawn: " + spawnPoint + ", Completion: " + completionPoint);
        return true;
    }

    @Nullable
    public final class_3218 getChallengeLevel(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return server.method_3847(CHALLENGE_DIMENSION_KEY);
    }

    public final boolean canDoChallenge(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        return !state.getChallengeCompleted() && state.getLostHearts() > 0;
    }

    public final void showChallengeQuestion(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        if (state.getChallengeCompleted()) {
            logger.info(player.method_7334().name() + " already completed challenge, skipping question");
            return;
        }
        if (state.getLostHearts() == 0) {
            logger.info(player.method_7334().name() + " has no lost hearts, skipping challenge question");
            return;
        }
        state.setPendingChallengeChoice(true);
        player.method_64398((class_2561)class_2561.method_43470((String)""));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l=== CHALLENGE OPPORTUNITY ==="));
        player.method_64398((class_2561)class_2561.method_43470((String)""));
        player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7eYou have lost \u00a7c" + state.getLostHearts() + "\u00a7e heart(s).")));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eYou can attempt a \u00a7bspecial challenge\u00a7e to restore ALL your hearts!"));
        player.method_64398((class_2561)class_2561.method_43470((String)""));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lWARNING: \u00a77This is a ONE-TIME opportunity!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77If you decline, you cannot do this later."));
        player.method_64398((class_2561)class_2561.method_43470((String)""));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aType \u00a7f/challenge accept\u00a7a to attempt the challenge"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cType \u00a7f/challenge decline\u00a7c to skip (keep reduced hearts)"));
        player.method_64398((class_2561)class_2561.method_43470((String)""));
        logger.info("Showed challenge question to " + player.method_7334().name());
    }

    public final boolean acceptChallenge(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        if (!state.getPendingChallengeChoice()) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have a pending challenge decision!"));
            return false;
        }
        if (state.getChallengeCompleted()) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou have already used your challenge opportunity!"));
            state.setPendingChallengeChoice(false);
            return false;
        }
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        if (minecraftServer == null) {
            return false;
        }
        MinecraftServer server = minecraftServer;
        if (!challengeSetup) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cChallenge world is not set up yet! Ask an admin to configure it."));
            return false;
        }
        class_3218 challengeLevel = this.getChallengeLevel(server);
        if (challengeLevel == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cChallenge dimension not found!"));
            return false;
        }
        state.setPendingChallengeChoice(false);
        state.setInChallengeWorld(true);
        this.teleportToChallenge(player);
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7lChallenge accepted!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eComplete the challenge to restore all your hearts!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77You will be returned to purgatory when done."));
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        DiscordNotifier.INSTANCE.onChallengeAccept(string, GameSessionManager.INSTANCE.getFormattedTime());
        logger.info(player.method_7334().name() + " accepted the challenge");
        return true;
    }

    public final boolean declineChallenge(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        if (!state.getPendingChallengeChoice()) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have a pending challenge decision!"));
            return false;
        }
        state.setPendingChallengeChoice(false);
        state.setChallengeCompleted(true);
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eYou declined the challenge."));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Waiting for your teammates to craft the revive totem..."));
        logger.info(player.method_7334().name() + " declined the challenge");
        return true;
    }

    public final void teleportToChallenge(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        class_3218 class_32182 = this.getChallengeLevel(server);
        if (class_32182 == null) {
            return;
        }
        class_3218 challengeLevel = class_32182;
        player.method_48105(challengeLevel, (double)challengeSpawnPoint.method_10263() + 0.5, (double)challengeSpawnPoint.method_10264(), (double)challengeSpawnPoint.method_10260() + 0.5, SetsKt.emptySet(), player.method_36454(), player.method_36455(), false);
        player.method_18799(class_243.field_1353);
        player.field_6017 = 0.0;
        player.method_5646();
        player.method_6033(player.method_6063());
        player.method_7344().method_7580(20);
        logger.info("Teleported " + player.method_7334().name() + " to challenge world at " + challengeSpawnPoint);
    }

    public final void onChallengeComplete(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        if (!state.getInChallengeWorld()) {
            logger.warn(player.method_7334().name() + " triggered challenge complete but wasn't in challenge world");
            return;
        }
        logger.info(player.method_7334().name() + " completed the challenge!");
        state.setLostHearts(0);
        state.setChallengeCompleted(true);
        state.setInChallengeWorld(false);
        DeathHandler.INSTANCE.applyMaxHealth(player, state);
        player.method_6033(20.0f);
        player.method_64398((class_2561)class_2561.method_43470((String)""));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7l=== CHALLENGE COMPLETE! ==="));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aAll your hearts have been restored!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Returning to purgatory..."));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Waiting for your teammates to craft the revive totem."));
        player.method_64398((class_2561)class_2561.method_43470((String)""));
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        DiscordNotifier.INSTANCE.onChallengeComplete(string, GameSessionManager.INSTANCE.getFormattedTime());
        DimensionManager.INSTANCE.teleportToPurgatory(player);
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        for (Object e : server.method_3760().method_14571()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            class_3222 p = (class_3222)e;
            if (Intrinsics.areEqual((Object)p.method_5667(), (Object)player.method_5667())) continue;
            p.method_64398((class_2561)class_2561.method_43470((String)("\u00a7a" + player.method_7334().name() + " completed the challenge and restored all hearts!")));
        }
    }

    public final void onChallengeFailure(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        if (!state.getInChallengeWorld()) {
            return;
        }
        logger.info(player.method_7334().name() + " failed the challenge");
        state.setInChallengeWorld(false);
        state.setChallengeCompleted(true);
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lChallenge failed!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Your hearts were not restored."));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Returning to purgatory..."));
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        DiscordNotifier.INSTANCE.onChallengeFail(string, GameSessionManager.INSTANCE.getFormattedTime());
        player.method_6033(state.getMaxHealth());
        player.method_5646();
        DimensionManager.INSTANCE.teleportToPurgatory(player);
    }

    public final boolean isInChallengeDimension(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Intrinsics.areEqual((Object)player.method_51469().method_27983(), CHALLENGE_DIMENSION_KEY);
    }

    public final void setSpawnPoint(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        challengeSpawnPoint = pos;
        logger.info("Challenge spawn point set to " + pos);
    }

    public final void setCompletionPoint(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        challengeCompletionPoint = pos;
        logger.info("Challenge completion point set to " + pos);
    }

    @NotNull
    public final class_2338 getCompletionPoint() {
        return challengeCompletionPoint;
    }

    public final void reset() {
        challengeSetup = false;
        challengeSpawnPoint = new class_2338(0, 100, 0);
        challengeCompletionPoint = new class_2338(0, 100, 50);
    }

    @NotNull
    public final class_2338 getSpawnPoint() {
        return challengeSpawnPoint;
    }

    public final void setChallengeSetup(boolean setup) {
        challengeSetup = setup;
    }

    static {
        class_5321 class_53212 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"challenge"));
        Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"create(...)");
        CHALLENGE_DIMENSION_KEY = class_53212;
        challengeSpawnPoint = new class_2338(0, 100, 0);
        challengeCompletionPoint = new class_2338(0, 100, 50);
    }
}

