/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.ChallengeManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0016R\u001c\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010!\u00a8\u0006#"}, d2={"Lrevive/mod/ChallengeDimensionLoader;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initializeChallengeWorld", "(Lnet/minecraft/server/MinecraftServer;)V", "Ljava/nio/file/Path;", "worldFolder", "Lnet/minecraft/class_3218;", "level", "Ljava/io/File;", "getDimensionFolder", "(Ljava/nio/file/Path;Lnet/minecraft/class_3218;)Ljava/io/File;", "regionFolder", "extractRegionFiles", "(Ljava/io/File;)V", "setupChallengeDefaults", "", "isChallengeWorldLoaded", "(Lnet/minecraft/server/MinecraftServer;)Z", "forceReloadChallengeWorld", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "MOD_ID", "Ljava/lang/String;", "Lnet/minecraft/class_2338;", "DEFAULT_SPAWN", "Lnet/minecraft/class_2338;", "DEFAULT_COMPLETION", "hardcore-mod"})
@SourceDebugExtension(value={"SMAP\nChallengeDimensionLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChallengeDimensionLoader.kt\nrevive/mod/ChallengeDimensionLoader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n13225#2,2:190\n3938#2:192\n4474#2,2:193\n1915#3,2:195\n*S KotlinDebug\n*F\n+ 1 ChallengeDimensionLoader.kt\nrevive/mod/ChallengeDimensionLoader\n*L\n50#1:190,2\n176#1:192\n176#1:193,2\n176#1:195,2\n*E\n"})
public final class ChallengeDimensionLoader {
    @NotNull
    public static final ChallengeDimensionLoader INSTANCE = new ChallengeDimensionLoader();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    public static final String MOD_ID = "hardcore-mod";
    @NotNull
    private static final class_2338 DEFAULT_SPAWN = new class_2338(0, 100, 0);
    @NotNull
    private static final class_2338 DEFAULT_COMPLETION = new class_2338(0, 100, 50);

    private ChallengeDimensionLoader() {
    }

    public final void initializeChallengeWorld(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        logger.info("Initializing challenge dimension...");
        class_3218 challengeLevel = ChallengeManager.INSTANCE.getChallengeLevel(server);
        if (challengeLevel == null) {
            logger.error("Challenge dimension not found! Make sure dimension is registered.");
            return;
        }
        Path path = server.method_3831();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getServerDirectory(...)");
        Path worldFolder = path;
        File dimensionFolder = this.getDimensionFolder(worldFolder, challengeLevel);
        if (dimensionFolder == null) {
            logger.error("Could not determine dimension folder for challenge dimension");
            return;
        }
        File regionFolder = new File(dimensionFolder, "region");
        if (regionFolder.exists()) {
            boolean bl;
            File[] fileArray = regionFolder.listFiles();
            if (fileArray != null) {
                boolean bl2;
                block7: {
                    File[] $this$any$iv = fileArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"mca")) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            if (bl) {
                logger.info("Challenge world region files already exist, skipping extraction");
                this.setupChallengeDefaults(server);
                return;
            }
        }
        this.extractRegionFiles(regionFolder);
        this.setupChallengeDefaults(server);
        logger.info("Challenge dimension initialized successfully!");
    }

    private final File getDimensionFolder(Path worldFolder, class_3218 level) {
        Path dimensionsFolder = worldFolder.resolve("dimensions").resolve(MOD_ID).resolve("challenge");
        return dimensionsFolder.toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void extractRegionFiles(File regionFolder) {
        logger.info("Extracting challenge world region files to: " + regionFolder.getAbsolutePath());
        if (!regionFolder.exists()) {
            regionFolder.mkdirs();
        }
        Object[] objectArray = new String[]{"r.0.0.mca", "r.0.1.mca", "r.0.-1.mca", "r.0.-2.mca", "r.1.0.mca", "r.-1.0.mca", "r.1.1.mca", "r.1.-1.mca", "r.-1.1.mca", "r.-1.-1.mca", "r.1.-2.mca", "r.-1.-2.mca", "r.-2.0.mca", "r.-2.1.mca", "r.-2.-1.mca", "r.-2.-2.mca"};
        List regionFiles = CollectionsKt.listOf((Object[])objectArray);
        int extractedCount = 0;
        for (String fileName : regionFiles) {
            try {
                String resourcePath = "/data/hardcore-mod/challenge_world/region/" + fileName;
                InputStream inputStream = ChallengeDimensionLoader.class.getResourceAsStream(resourcePath);
                if (inputStream == null) {
                    logger.warn("Region file not found in resources: " + resourcePath);
                    continue;
                }
                File outputFile = new File(regionFolder, fileName);
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    long l;
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    Closeable closeable2 = new FileOutputStream(outputFile);
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream output = (FileOutputStream)closeable2;
                        boolean bl2 = false;
                        l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                ++extractedCount;
                logger.debug("Extracted region file: " + fileName);
            }
            catch (Exception e) {
                logger.error("Failed to extract region file: " + fileName, (Throwable)e);
            }
        }
        logger.info("Extracted " + extractedCount + " region files to challenge dimension");
    }

    private final void setupChallengeDefaults(MinecraftServer server) {
        ChallengeManager.INSTANCE.setupChallenge(server, DEFAULT_SPAWN, DEFAULT_COMPLETION);
        logger.info("Challenge world configured with default spawn: " + DEFAULT_SPAWN + ", completion: " + DEFAULT_COMPLETION);
    }

    public final boolean isChallengeWorldLoaded(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 challengeLevel = ChallengeManager.INSTANCE.getChallengeLevel(server);
        return challengeLevel != null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean forceReloadChallengeWorld(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 challengeLevel = ChallengeManager.INSTANCE.getChallengeLevel(server);
        if (challengeLevel == null) {
            logger.error("Challenge dimension not available");
            return false;
        }
        Path path = server.method_3831();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getServerDirectory(...)");
        Path worldFolder = path;
        File dimensionFolder = this.getDimensionFolder(worldFolder, challengeLevel);
        if (dimensionFolder == null) {
            logger.error("Could not determine dimension folder");
            return false;
        }
        File regionFolder = new File(dimensionFolder, "region");
        if (regionFolder.exists()) {
            File[] fileArray = regionFolder.listFiles();
            if (fileArray != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"mca")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    it.delete();
                }
            }
        }
        this.extractRegionFiles(regionFolder);
        this.setupChallengeDefaults(server);
        logger.info("Challenge world reloaded!");
        return true;
    }
}

