/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.skills;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.skills.ClientSkillCache;
import revive.mod.skills.ClientSkillData;
import revive.mod.skills.ClientSkillNetwork;
import revive.mod.skills.SkillType;
import revive.mod.skills.SkillUpgrade;
import revive.mod.skills.SkillUpgrades;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J/\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0017\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\t8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\t8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001aR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lrevive/mod/skills/SkillsScreen;", "Lnet/minecraft/class_437;", "<init>", "()V", "", "init", "rebuildUpgradeButtons", "Lnet/minecraft/class_332;", "graphics", "", "mouseX", "mouseY", "", "delta", "render", "(Lnet/minecraft/class_332;IIF)V", "drawUpgradeTooltip", "(Lnet/minecraft/class_332;II)V", "", "isPauseScreen", "()Z", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "guiLeft", "I", "guiTop", "guiWidth", "guiHeight", "Lrevive/mod/skills/SkillType;", "selectedSkill", "Lrevive/mod/skills/SkillType;", "Lrevive/mod/skills/ClientSkillData;", "cachedSkillData", "Lrevive/mod/skills/ClientSkillData;", "hardcore-mod_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nSkillsScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkillsScreen.kt\nrevive/mod/skills/SkillsScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class SkillsScreen
extends class_437 {
    private final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod-skills");
    private int guiLeft;
    private int guiTop;
    private final int guiWidth;
    private final int guiHeight;
    @Nullable
    private SkillType selectedSkill;
    @Nullable
    private ClientSkillData cachedSkillData;

    public SkillsScreen() {
        super((class_2561)class_2561.method_43470((String)"Skills"));
        this.guiWidth = 280;
        this.guiHeight = 200;
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - this.guiWidth) / 2;
        this.guiTop = (this.field_22790 - this.guiHeight) / 2;
        this.cachedSkillData = ClientSkillCache.INSTANCE.getSkillData();
        int yOffset = 0;
        for (SkillType skill : SkillType.getEntries()) {
            class_4185 skillButton;
            Intrinsics.checkNotNullExpressionValue((Object)class_4185.method_46430((class_2561)((class_2561)class_2561.method_43470((String)skill.getDisplayName())), arg_0 -> SkillsScreen.init$lambda$0(this, skill, arg_0)).method_46433(this.guiLeft + 10, this.guiTop + 30 + yOffset).method_46437(80, 20).method_46431(), (String)"build(...)");
            this.method_37063((class_364)skillButton);
            yOffset += 25;
        }
        if (this.selectedSkill == null && !((Collection)SkillType.getEntries()).isEmpty()) {
            this.selectedSkill = (SkillType)((Object)CollectionsKt.first((List)((List)SkillType.getEntries())));
        }
        this.rebuildUpgradeButtons();
    }

    private final void rebuildUpgradeButtons() {
        int skillButtonCount = SkillType.getEntries().size();
        while (this.method_25396().size() > skillButtonCount) {
            class_364 widget;
            List list = this.method_25396();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"children(...)");
            if ((class_364)CollectionsKt.lastOrNull((List)list) == null || !(widget instanceof class_4185)) break;
            this.method_37066(widget);
        }
        SkillType skillType = this.selectedSkill;
        if (skillType == null) {
            return;
        }
        SkillType skill = skillType;
        ClientSkillData clientSkillData = this.cachedSkillData;
        if (clientSkillData == null) {
            return;
        }
        ClientSkillData skillData = clientSkillData;
        List<SkillUpgrade> upgrades = SkillUpgrades.INSTANCE.getUpgradesForSkill(skill);
        int yOffset = 0;
        for (SkillUpgrade upgrade : upgrades) {
            class_4185 upgradeButton;
            int tier = skillData.getUpgradeTier(upgrade.getId());
            boolean canUnlock = skillData.canUnlockUpgrade(upgrade);
            boolean isMaxed = tier >= upgrade.getMaxTier();
            String buttonText = isMaxed ? upgrade.getName() + " [MAX]" : (tier > 0 ? upgrade.getName() + " [" + tier + "/" + upgrade.getMaxTier() + "]" : upgrade.getName() + " [0/" + upgrade.getMaxTier() + "]");
            Intrinsics.checkNotNullExpressionValue((Object)class_4185.method_46430((class_2561)((class_2561)class_2561.method_43470((String)buttonText)), arg_0 -> SkillsScreen.rebuildUpgradeButtons$lambda$0(isMaxed, canUnlock, upgrade, arg_0)).method_46433(this.guiLeft + 100, this.guiTop + 30 + yOffset).method_46437(170, 20).method_46431(), (String)"build(...)");
            upgradeButton.field_22763 = !isMaxed && canUnlock;
            this.method_37063((class_364)upgradeButton);
            yOffset += 25;
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        this.method_25420(graphics, mouseX, mouseY, delta);
        graphics.method_25294(this.guiLeft, this.guiTop, this.guiLeft + this.guiWidth, this.guiTop + this.guiHeight, -872415232);
        graphics.method_73198(this.guiLeft, this.guiTop, this.guiWidth, this.guiHeight, -1);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.guiTop + 10, 0xFFFFFF);
        SkillType skill = this.selectedSkill;
        ClientSkillData skillData = this.cachedSkillData;
        if (skill != null && skillData != null) {
            int level = skillData.getLevel(skill);
            int xpInLevel = skillData.getXpInCurrentLevel(skill);
            int xpToNext = skillData.getXpToNextLevel(skill);
            float progress = skillData.getLevelProgress(skill);
            int points = skillData.getSkillPoints(skill);
            int skillColor = switch (WhenMappings.$EnumSwitchMapping$0[skill.ordinal()]) {
                case 1 -> 0x55FFFF;
                case 2 -> 43520;
                case 3 -> 43690;
                case 4 -> 0xFF5555;
                case 5 -> 0x55FF55;
                case 6 -> 0xFFAA00;
                default -> throw new NoWhenBranchMatchedException();
            };
            int infoX = this.guiLeft + this.guiWidth - 90;
            graphics.method_25303(this.field_22793, String.valueOf(skill.getDisplayName()), infoX, this.guiTop + 30, skillColor);
            graphics.method_25303(this.field_22793, "Level: " + level, infoX, this.guiTop + 42, 0xFFFFFF);
            int barWidth = 80;
            int barHeight = 8;
            int barX = infoX;
            int barY = this.guiTop + 55;
            int filledWidth = (int)(progress * (float)barWidth);
            graphics.method_25294(barX, barY, barX + barWidth, barY + barHeight, -13421773);
            graphics.method_25294(barX, barY, barX + filledWidth, barY + barHeight, -16733696);
            graphics.method_73198(barX, barY, barWidth, barHeight, -7829368);
            graphics.method_25303(this.field_22793, xpInLevel + "/" + xpToNext + " XP", infoX, this.guiTop + 66, 0xAAAAAA);
            if (points > 0) {
                graphics.method_25303(this.field_22793, "Points: " + points, infoX, this.guiTop + 80, 0x55FF55);
            } else {
                graphics.method_25303(this.field_22793, "Points: 0", infoX, this.guiTop + 80, 0x888888);
            }
        }
        this.drawUpgradeTooltip(graphics, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    private final void drawUpgradeTooltip(class_332 graphics, int mouseX, int mouseY) {
        SkillType skillType = this.selectedSkill;
        if (skillType == null) {
            return;
        }
        SkillType skill = skillType;
        ClientSkillData clientSkillData = this.cachedSkillData;
        if (clientSkillData == null) {
            return;
        }
        ClientSkillData skillData = clientSkillData;
        List<SkillUpgrade> upgrades = SkillUpgrades.INSTANCE.getUpgradesForSkill(skill);
        int yOffset = 0;
        for (SkillUpgrade upgrade : upgrades) {
            int buttonX = this.guiLeft + 100;
            int buttonY = this.guiTop + 30 + yOffset;
            int buttonWidth = 170;
            int buttonHeight = 20;
            if (mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight) {
                Comparable comparable;
                int tooltipY;
                int tier = skillData.getUpgradeTier(upgrade.getId());
                int nextTier = tier + 1;
                int requiredLevel = upgrade.getLevelForTier(nextTier);
                List tooltipLines = new ArrayList();
                class_5250 class_52502 = class_2561.method_43470((String)("\u00a7e" + upgrade.getName()));
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
                tooltipLines.add(class_52502);
                class_5250 class_52503 = class_2561.method_43470((String)("\u00a77" + upgrade.getDescription()));
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
                tooltipLines.add(class_52503);
                if (tier < upgrade.getMaxTier()) {
                    int nextEffect = (int)(upgrade.getEffectAtTier(nextTier) * (float)100);
                    class_5250 class_52504 = class_2561.method_43470((String)("\u00a7aNext tier: +" + nextEffect + "%"));
                    Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
                    tooltipLines.add(class_52504);
                    class_5250 class_52505 = class_2561.method_43470((String)("\u00a77Requires: Lv." + requiredLevel + ", " + upgrade.getPointsPerTier() + " points"));
                    Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"literal(...)");
                    tooltipLines.add(class_52505);
                    String prereqId = upgrade.getPrerequisiteId();
                    if (prereqId != null && skillData.getUpgradeTier(prereqId) < 1) {
                        SkillUpgrade prereq = SkillUpgrades.INSTANCE.getUpgradeById(prereqId);
                        Object object = prereq;
                        if (object == null || (object = ((SkillUpgrade)object).getName()) == null) {
                            object = prereqId;
                        }
                        class_5250 class_52506 = class_2561.method_43470((String)("\u00a7cNeeds: " + (String)object));
                        Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"literal(...)");
                        tooltipLines.add(class_52506);
                    }
                } else {
                    class_5250 class_52507 = class_2561.method_43470((String)"\u00a72MAX TIER REACHED");
                    Intrinsics.checkNotNullExpressionValue((Object)class_52507, (String)"literal(...)");
                    tooltipLines.add(class_52507);
                }
                int lineY = tooltipY = mouseY + 10;
                Iterator iterator = ((Iterable)tooltipLines).iterator();
                if (!iterator.hasNext()) {
                    comparable = null;
                } else {
                    class_2561 it = (class_2561)iterator.next();
                    boolean bl = false;
                    Comparable comparable2 = Integer.valueOf(this.field_22793.method_1727(it.getString()));
                    while (iterator.hasNext()) {
                        class_2561 it2 = (class_2561)iterator.next();
                        $i$a$-maxOfOrNull-SkillsScreen$drawUpgradeTooltip$maxWidth$1 = false;
                        Comparable comparable3 = Integer.valueOf(this.field_22793.method_1727(it2.getString()));
                        if (comparable2.compareTo(comparable3) >= 0) continue;
                        comparable2 = comparable3;
                    }
                    comparable = comparable2;
                }
                Integer n = (Integer)comparable;
                int maxWidth = n != null ? n : 100;
                graphics.method_25294(mouseX, tooltipY - 2, mouseX + maxWidth + 8, tooltipY + tooltipLines.size() * 10 + 4, -267386864);
                graphics.method_73198(mouseX, tooltipY - 2, maxWidth + 8, tooltipLines.size() * 10 + 6, -11513776);
                for (class_2561 line : tooltipLines) {
                    graphics.method_27535(this.field_22793, line, mouseX + 4, lineY, 0xFFFFFF);
                    lineY += 10;
                }
                break;
            }
            yOffset += 25;
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static final void init$lambda$0(SkillsScreen this$0, SkillType $skill, class_4185 button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this$0.selectedSkill = $skill;
        this$0.rebuildUpgradeButtons();
    }

    private static final void rebuildUpgradeButtons$lambda$0(boolean $isMaxed, boolean $canUnlock, SkillUpgrade $upgrade, class_4185 button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        if (!$isMaxed && $canUnlock) {
            ClientSkillNetwork.INSTANCE.sendUnlockRequest($upgrade.getId());
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    @Environment(value=EnvType.CLIENT)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SkillType.values().length];
            try {
                nArray[SkillType.MINING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkillType.WOODCUTTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkillType.FISHING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkillType.COMBAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkillType.FARMING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkillType.EXCAVATION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

