/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.skills;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revive.mod.skills.PlayerSkillData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0019\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0003R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lrevive/mod/skills/SkillDataManager;", "", "<init>", "()V", "Ljava/util/UUID;", "uuid", "", "playerName", "Lrevive/mod/skills/PlayerSkillData;", "getPlayerData", "(Ljava/util/UUID;Ljava/lang/String;)Lrevive/mod/skills/PlayerSkillData;", "(Ljava/util/UUID;)Lrevive/mod/skills/PlayerSkillData;", "", "getAllData", "()Ljava/util/Map;", "data", "", "loadFromSavedData", "(Ljava/util/Map;)V", "reset", "Ljava/util/concurrent/ConcurrentHashMap;", "playerData", "Ljava/util/concurrent/ConcurrentHashMap;", "hardcore-mod"})
public final class SkillDataManager {
    @NotNull
    public static final SkillDataManager INSTANCE = new SkillDataManager();
    @NotNull
    private static final ConcurrentHashMap<UUID, PlayerSkillData> playerData = new ConcurrentHashMap();

    private SkillDataManager() {
    }

    @NotNull
    public final PlayerSkillData getPlayerData(@NotNull UUID uuid, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerSkillData playerSkillData = playerData.computeIfAbsent(uuid, arg_0 -> SkillDataManager.getPlayerData$lambda$1(arg_0 -> SkillDataManager.getPlayerData$lambda$0(uuid, playerName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)playerSkillData, (String)"computeIfAbsent(...)");
        return playerSkillData;
    }

    @Nullable
    public final PlayerSkillData getPlayerData(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return playerData.get(uuid);
    }

    @NotNull
    public final Map<UUID, PlayerSkillData> getAllData() {
        return MapsKt.toMap((Map)playerData);
    }

    public final void loadFromSavedData(@NotNull Map<UUID, PlayerSkillData> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        playerData.clear();
        playerData.putAll(data);
    }

    public final void reset() {
        playerData.clear();
    }

    private static final PlayerSkillData getPlayerData$lambda$0(UUID $uuid, String $playerName, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new PlayerSkillData($uuid, $playerName, null, null, null, 28, null);
    }

    private static final PlayerSkillData getPlayerData$lambda$1(Function1 $tmp0, Object p0) {
        return (PlayerSkillData)$tmp0.invoke(p0);
    }
}

