/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.skills;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revive.mod.skills.SkillType;
import revive.mod.skills.SkillUpgrade;
import revive.mod.skills.SkillUpgrades;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0019\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001ABY\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0010J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0010J\u001d\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\b\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0010J\r\u0010\u001b\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\"2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b%\u0010$J\u0015\u0010&\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\b\u00a2\u0006\u0004\b(\u0010\u001cJ\u0019\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010)\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010,\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b,\u0010-J\u0010\u0010.\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b.\u0010/J\u001c\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c2\u0003\u00a2\u0006\u0004\b0\u0010+J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0006H\u00c2\u0003\u00a2\u0006\u0004\b1\u0010+J\u001c\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c2\u0003\u00a2\u0006\u0004\b2\u0010+Jf\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00062\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001\u00a2\u0006\u0004\b3\u00104J\u001b\u00106\u001a\u00020\"2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004\u00a2\u0006\u0004\b6\u00107J\u0011\u00108\u001a\u00020\bH\u00d6\u0081\u0004\u00a2\u0006\u0004\b8\u0010\u001cJ\u0011\u00109\u001a\u00020\u0004H\u00d6\u0081\u0004\u00a2\u0006\u0004\b9\u0010/R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010:\u001a\u0004\b;\u0010-R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010<\u001a\u0004\b=\u0010/\"\u0004\b>\u0010?R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010@R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010@R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010@\u00a8\u0006B"}, d2={"Lrevive/mod/skills/PlayerSkillData;", "", "Ljava/util/UUID;", "uuid", "", "playerName", "", "Lrevive/mod/skills/SkillType;", "", "skillXp", "unlockedUpgrades", "skillPoints", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "skillType", "getXp", "(Lrevive/mod/skills/SkillType;)I", "getLevel", "", "getLevelProgress", "(Lrevive/mod/skills/SkillType;)F", "getXpToNextLevel", "getXpInCurrentLevel", "amount", "addXp", "(Lrevive/mod/skills/SkillType;I)I", "getSkillPoints", "getTotalSkillPoints", "()I", "upgradeId", "getUpgradeTier", "(Ljava/lang/String;)I", "Lrevive/mod/skills/SkillUpgrade;", "upgrade", "", "canUnlockUpgrade", "(Lrevive/mod/skills/SkillUpgrade;)Z", "unlockUpgrade", "getUpgradeEffect", "(Ljava/lang/String;)F", "getTotalLevel", "", "serialize", "()Ljava/util/Map;", "component1", "()Ljava/util/UUID;", "component2", "()Ljava/lang/String;", "component3", "component4", "component5", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)Lrevive/mod/skills/PlayerSkillData;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/util/UUID;", "getUuid", "Ljava/lang/String;", "getPlayerName", "setPlayerName", "(Ljava/lang/String;)V", "Ljava/util/Map;", "Companion", "hardcore-mod"})
@SourceDebugExtension(value={"SMAP\nPlayerSkillData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerSkillData.kt\nrevive/mod/skills/PlayerSkillData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1#2:244\n481#3:245\n427#3:246\n481#3:251\n427#3:252\n1266#4,4:247\n1266#4,4:253\n*S KotlinDebug\n*F\n+ 1 PlayerSkillData.kt\nrevive/mod/skills/PlayerSkillData\n*L\n173#1:245\n173#1:246\n175#1:251\n175#1:252\n173#1:247,4\n175#1:253,4\n*E\n"})
public final class PlayerSkillData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID uuid;
    @NotNull
    private String playerName;
    @NotNull
    private final Map<SkillType, Integer> skillXp;
    @NotNull
    private final Map<String, Integer> unlockedUpgrades;
    @NotNull
    private final Map<SkillType, Integer> skillPoints;

    public PlayerSkillData(@NotNull UUID uuid, @NotNull String playerName, @NotNull Map<SkillType, Integer> skillXp, @NotNull Map<String, Integer> unlockedUpgrades, @NotNull Map<SkillType, Integer> skillPoints) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter(skillXp, (String)"skillXp");
        Intrinsics.checkNotNullParameter(unlockedUpgrades, (String)"unlockedUpgrades");
        Intrinsics.checkNotNullParameter(skillPoints, (String)"skillPoints");
        this.uuid = uuid;
        this.playerName = playerName;
        this.skillXp = skillXp;
        this.unlockedUpgrades = unlockedUpgrades;
        this.skillPoints = skillPoints;
    }

    public /* synthetic */ PlayerSkillData(UUID uUID, String string, Map map, Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 8) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 0x10) != 0) {
            map3 = new LinkedHashMap();
        }
        this(uUID, string, map, map2, map3);
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final String getPlayerName() {
        return this.playerName;
    }

    public final void setPlayerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.playerName = string;
    }

    public final int getXp(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        Integer n = this.skillXp.get((Object)skillType);
        return n != null ? n : 0;
    }

    public final int getLevel(@NotNull SkillType skillType) {
        int xpForNextLevel;
        int level;
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int xp = this.getXp(skillType);
        int totalXpNeeded = 0;
        for (level = 0; level < skillType.getMaxLevel() && totalXpNeeded + (xpForNextLevel = skillType.getXpForLevel(level + 1)) <= xp; ++level) {
            totalXpNeeded += xpForNextLevel;
        }
        return level;
    }

    public final float getLevelProgress(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int level = this.getLevel(skillType);
        if (level >= skillType.getMaxLevel()) {
            return 1.0f;
        }
        int currentLevelTotalXp = skillType.getTotalXpForLevel(level);
        int nextLevelXp = skillType.getXpForLevel(level + 1);
        int currentXp = this.getXp(skillType);
        int xpIntoLevel = currentXp - currentLevelTotalXp;
        return RangesKt.coerceIn((float)((float)xpIntoLevel / (float)nextLevelXp), (float)0.0f, (float)1.0f);
    }

    public final int getXpToNextLevel(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int level = this.getLevel(skillType);
        if (level >= skillType.getMaxLevel()) {
            return 0;
        }
        return skillType.getXpForLevel(level + 1);
    }

    public final int getXpInCurrentLevel(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int level = this.getLevel(skillType);
        int totalXpForLevel = skillType.getTotalXpForLevel(level);
        return this.getXp(skillType) - totalXpForLevel;
    }

    public final int addXp(@NotNull SkillType skillType, int amount) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int oldLevel = this.getLevel(skillType);
        Map<SkillType, Integer> map = this.skillXp;
        Integer n = this.skillXp.get((Object)skillType);
        Integer n2 = (n != null ? n : 0) + amount;
        map.put(skillType, n2);
        int newLevel = this.getLevel(skillType);
        int levelsGained = newLevel - oldLevel;
        if (levelsGained > 0) {
            Map<SkillType, Integer> map2 = this.skillPoints;
            Integer n3 = this.skillPoints.get((Object)skillType);
            Integer n4 = (n3 != null ? n3 : 0) + levelsGained;
            map2.put(skillType, n4);
        }
        return levelsGained;
    }

    public final int getSkillPoints(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        Integer n = this.skillPoints.get((Object)skillType);
        return n != null ? n : 0;
    }

    public final int getTotalSkillPoints() {
        return CollectionsKt.sumOfInt((Iterable)this.skillPoints.values());
    }

    public final int getUpgradeTier(@NotNull String upgradeId) {
        Intrinsics.checkNotNullParameter((Object)upgradeId, (String)"upgradeId");
        Integer n = this.unlockedUpgrades.get(upgradeId);
        return n != null ? n : 0;
    }

    public final boolean canUnlockUpgrade(@NotNull SkillUpgrade upgrade) {
        int prereqTier;
        Intrinsics.checkNotNullParameter((Object)upgrade, (String)"upgrade");
        int currentTier = this.getUpgradeTier(upgrade.getId());
        if (currentTier >= upgrade.getMaxTier()) {
            return false;
        }
        int requiredLevel = upgrade.getLevelForTier(currentTier + 1);
        if (this.getLevel(upgrade.getSkillType()) < requiredLevel) {
            return false;
        }
        if (this.getSkillPoints(upgrade.getSkillType()) < upgrade.getPointsPerTier()) {
            return false;
        }
        return upgrade.getPrerequisiteId() == null || (prereqTier = this.getUpgradeTier(upgrade.getPrerequisiteId())) >= 1;
    }

    public final boolean unlockUpgrade(@NotNull SkillUpgrade upgrade) {
        Intrinsics.checkNotNullParameter((Object)upgrade, (String)"upgrade");
        if (!this.canUnlockUpgrade(upgrade)) {
            return false;
        }
        Map<Object, Integer> map = this.skillPoints;
        Object object = upgrade.getSkillType();
        Integer n = this.skillPoints.get((Object)upgrade.getSkillType());
        Integer n2 = (n != null ? n : 0) - upgrade.getPointsPerTier();
        map.put(object, n2);
        map = this.unlockedUpgrades;
        object = upgrade.getId();
        Integer n3 = this.unlockedUpgrades.get(upgrade.getId());
        n2 = (n3 != null ? n3 : 0) + 1;
        map.put(object, n2);
        return true;
    }

    public final float getUpgradeEffect(@NotNull String upgradeId) {
        Intrinsics.checkNotNullParameter((Object)upgradeId, (String)"upgradeId");
        int tier = this.getUpgradeTier(upgradeId);
        if (tier <= 0) {
            return 0.0f;
        }
        SkillUpgrade skillUpgrade = SkillUpgrades.INSTANCE.getUpgradeById(upgradeId);
        if (skillUpgrade == null) {
            return 0.0f;
        }
        SkillUpgrade upgrade = skillUpgrade;
        return upgrade.getEffectAtTier(tier);
    }

    /*
     * WARNING - void declaration
     */
    public final int getTotalLevel() {
        Iterable iterable = (Iterable)SkillType.getEntries();
        int n = 0;
        for (Object t : iterable) {
            void it;
            SkillType skillType = (SkillType)((Object)t);
            int n2 = n;
            boolean bl = false;
            int n3 = this.getLevel((SkillType)it);
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public final Map<String, Object> serialize() {
        Map.Entry it$iv$iv;
        boolean bl;
        Map map;
        String string;
        Object it;
        Map map2;
        Map.Entry entry;
        Iterable $this$associateByTo$iv$iv$iv;
        Map<SkillType, Integer> $this$mapKeysTo$iv$iv;
        Map<SkillType, Integer> $this$mapKeys$iv;
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"uuid", (Object)this.uuid.toString());
        pairArray[1] = TuplesKt.to((Object)"playerName", (Object)this.playerName);
        Map<SkillType, Integer> map3 = this.skillXp;
        String string2 = "skillXp";
        int n = 2;
        Pair[] pairArray2 = pairArray;
        boolean $i$f$mapKeys = false;
        void var4_7 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable iterable = $this$mapKeysTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            string = ((SkillType)((Object)it.getKey())).name();
            map = map2;
            bl = false;
            it = it$iv$iv.getValue();
            map.put(string, it);
        }
        map2 = destination$iv$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string2, (Object)map2);
        pairArray[3] = TuplesKt.to((Object)"unlockedUpgrades", this.unlockedUpgrades);
        $this$mapKeys$iv = this.skillPoints;
        string2 = "skillPoints";
        n = 4;
        pairArray2 = pairArray;
        $i$f$mapKeys = false;
        $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        destination$iv$iv$iv = destination$iv$iv;
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv$iv;
            boolean bl3 = false;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            string = ((SkillType)((Object)it.getKey())).name();
            map = map2;
            bl = false;
            entry = it$iv$iv.getValue();
            map.put(string, entry);
        }
        map2 = destination$iv$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string2, (Object)map2);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final UUID component1() {
        return this.uuid;
    }

    @NotNull
    public final String component2() {
        return this.playerName;
    }

    private final Map<SkillType, Integer> component3() {
        return this.skillXp;
    }

    private final Map<String, Integer> component4() {
        return this.unlockedUpgrades;
    }

    private final Map<SkillType, Integer> component5() {
        return this.skillPoints;
    }

    @NotNull
    public final PlayerSkillData copy(@NotNull UUID uuid, @NotNull String playerName, @NotNull Map<SkillType, Integer> skillXp, @NotNull Map<String, Integer> unlockedUpgrades, @NotNull Map<SkillType, Integer> skillPoints) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter(skillXp, (String)"skillXp");
        Intrinsics.checkNotNullParameter(unlockedUpgrades, (String)"unlockedUpgrades");
        Intrinsics.checkNotNullParameter(skillPoints, (String)"skillPoints");
        return new PlayerSkillData(uuid, playerName, skillXp, unlockedUpgrades, skillPoints);
    }

    public static /* synthetic */ PlayerSkillData copy$default(PlayerSkillData playerSkillData, UUID uUID, String string, Map map, Map map2, Map map3, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = playerSkillData.uuid;
        }
        if ((n & 2) != 0) {
            string = playerSkillData.playerName;
        }
        if ((n & 4) != 0) {
            map = playerSkillData.skillXp;
        }
        if ((n & 8) != 0) {
            map2 = playerSkillData.unlockedUpgrades;
        }
        if ((n & 0x10) != 0) {
            map3 = playerSkillData.skillPoints;
        }
        return playerSkillData.copy(uUID, string, map, map2, map3);
    }

    @NotNull
    public String toString() {
        return "PlayerSkillData(uuid=" + this.uuid + ", playerName=" + this.playerName + ", skillXp=" + this.skillXp + ", unlockedUpgrades=" + this.unlockedUpgrades + ", skillPoints=" + this.skillPoints + ")";
    }

    public int hashCode() {
        int result = this.uuid.hashCode();
        result = result * 31 + this.playerName.hashCode();
        result = result * 31 + ((Object)this.skillXp).hashCode();
        result = result * 31 + ((Object)this.unlockedUpgrades).hashCode();
        result = result * 31 + ((Object)this.skillPoints).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlayerSkillData)) {
            return false;
        }
        PlayerSkillData playerSkillData = (PlayerSkillData)other;
        if (!Intrinsics.areEqual((Object)this.uuid, (Object)playerSkillData.uuid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.playerName, (Object)playerSkillData.playerName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.skillXp, playerSkillData.skillXp)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.unlockedUpgrades, playerSkillData.unlockedUpgrades)) {
            return false;
        }
        return Intrinsics.areEqual(this.skillPoints, playerSkillData.skillPoints);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00072\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lrevive/mod/skills/PlayerSkillData$Companion;", "", "<init>", "()V", "", "", "data", "Lrevive/mod/skills/PlayerSkillData;", "deserialize", "(Ljava/util/Map;)Lrevive/mod/skills/PlayerSkillData;", "hardcore-mod"})
    @SourceDebugExtension(value={"SMAP\nPlayerSkillData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerSkillData.kt\nrevive/mod/skills/PlayerSkillData$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n481#2:244\n427#2:245\n481#2:250\n427#2:251\n1266#3,4:246\n1266#3,4:252\n*S KotlinDebug\n*F\n+ 1 PlayerSkillData.kt\nrevive/mod/skills/PlayerSkillData$Companion\n*L\n188#1:244\n188#1:245\n194#1:250\n194#1:251\n188#1:246,4\n194#1:252,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PlayerSkillData deserialize(@NotNull Map<String, ? extends Object> data) {
            Map map;
            Map unlockedUpgrades;
            Map skillXp;
            String playerName;
            UUID uuid;
            block12: {
                block11: {
                    void $this$associateByTo$iv$iv$iv;
                    void $this$mapKeysTo$iv$iv;
                    Object object;
                    Object object2;
                    Map map2;
                    Map.Entry it$iv$iv;
                    Object object3;
                    Map.Entry entry;
                    Map map3;
                    block10: {
                        Map map4;
                        block9: {
                            void $this$associateByTo$iv$iv$iv2;
                            void $this$mapKeysTo$iv$iv2;
                            Intrinsics.checkNotNullParameter(data, (String)"data");
                            Object object4 = data.get("uuid");
                            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
                            uuid = UUID.fromString((String)object4);
                            Object object5 = data.get("playerName");
                            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.String");
                            playerName = (String)object5;
                            Object object6 = data.get("skillXp");
                            map4 = object6 instanceof Map ? (Map)object6 : null;
                            if (map4 == null) break block9;
                            Map $this$mapKeys$iv = map4;
                            boolean $i$f$mapKeys = false;
                            Map map5 = $this$mapKeys$iv;
                            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                            boolean $i$f$mapKeysTo = false;
                            Iterable iterable = $this$mapKeysTo$iv$iv2.entrySet();
                            Map destination$iv$iv$iv = destination$iv$iv;
                            boolean $i$f$associateByTo = false;
                            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                                void it;
                                Object object7 = (Map.Entry)element$iv$iv$iv;
                                map3 = destination$iv$iv$iv;
                                boolean bl = false;
                                entry = (Map.Entry)element$iv$iv$iv;
                                SkillType skillType = SkillType.valueOf((String)it.getKey());
                                object3 = map3;
                                boolean bl2 = false;
                                object7 = it$iv$iv.getValue();
                                object3.put(skillType, object7);
                            }
                            map4 = MapsKt.toMutableMap((Map)destination$iv$iv$iv);
                            if (map4 != null) break block10;
                        }
                        map4 = skillXp = (Map)new LinkedHashMap();
                    }
                    if ((map2 = (object2 = data.get("unlockedUpgrades")) instanceof Map ? (Map)object2 : null) == null || (map2 = MapsKt.toMutableMap((Map)map2)) == null) {
                        map2 = unlockedUpgrades = (Map)new LinkedHashMap();
                    }
                    if ((map = (object = data.get("skillPoints")) instanceof Map ? (Map)object : null) == null) break block11;
                    Map $this$mapKeys$iv = map;
                    boolean $i$f$mapKeys = false;
                    Map $i$f$mapKeysTo = $this$mapKeys$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                    boolean $i$f$mapKeysTo2 = false;
                    Iterable $i$f$associateByTo = $this$mapKeysTo$iv$iv.entrySet();
                    Map destination$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$associateByTo2 = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv2;
                        void it;
                        it$iv$iv = (Map.Entry)element$iv$iv$iv;
                        map3 = destination$iv$iv$iv;
                        boolean bl = false;
                        object3 = (Map.Entry)element$iv$iv$iv;
                        SkillType skillType = SkillType.valueOf((String)it.getKey());
                        Map map6 = map3;
                        boolean bl3 = false;
                        entry = it$iv$iv2.getValue();
                        map6.put(skillType, entry);
                    }
                    map = MapsKt.toMutableMap((Map)destination$iv$iv$iv);
                    if (map != null) break block12;
                }
                map = new LinkedHashMap();
            }
            Map skillPoints = map;
            Intrinsics.checkNotNull((Object)uuid);
            return new PlayerSkillData(uuid, playerName, skillXp, unlockedUpgrades, skillPoints);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

