/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.skills;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import revive.mod.skills.SkillType;
import revive.mod.skills.SkillUpgrade;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\fJ\u0015\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\fJ\u001d\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\nJ\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\fJ\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!R \u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010$R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010$\u00a8\u0006'"}, d2={"Lrevive/mod/skills/ClientSkillData;", "", "<init>", "()V", "Lrevive/mod/skills/SkillType;", "skillType", "", "xp", "", "setXp", "(Lrevive/mod/skills/SkillType;I)V", "getXp", "(Lrevive/mod/skills/SkillType;)I", "getLevel", "", "getLevelProgress", "(Lrevive/mod/skills/SkillType;)F", "getXpToNextLevel", "getXpInCurrentLevel", "", "upgradeId", "tier", "setUpgradeTier", "(Ljava/lang/String;I)V", "getUpgradeTier", "(Ljava/lang/String;)I", "points", "setSkillPoints", "getSkillPoints", "Lrevive/mod/skills/SkillUpgrade;", "upgrade", "", "canUnlockUpgrade", "(Lrevive/mod/skills/SkillUpgrade;)Z", "", "skillXp", "Ljava/util/Map;", "unlockedUpgrades", "skillPoints", "hardcore-mod_client"})
@Environment(value=EnvType.CLIENT)
public final class ClientSkillData {
    @NotNull
    private final Map<SkillType, Integer> skillXp = new LinkedHashMap();
    @NotNull
    private final Map<String, Integer> unlockedUpgrades = new LinkedHashMap();
    @NotNull
    private final Map<SkillType, Integer> skillPoints = new LinkedHashMap();

    public final void setXp(@NotNull SkillType skillType, int xp) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        this.skillXp.put(skillType, xp);
    }

    public final int getXp(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        Integer n = this.skillXp.get((Object)skillType);
        return n != null ? n : 0;
    }

    public final int getLevel(@NotNull SkillType skillType) {
        int xpForNextLevel;
        int level;
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int xp = this.getXp(skillType);
        int totalXpNeeded = 0;
        for (level = 0; level < skillType.getMaxLevel() && totalXpNeeded + (xpForNextLevel = skillType.getXpForLevel(level + 1)) <= xp; ++level) {
            totalXpNeeded += xpForNextLevel;
        }
        return level;
    }

    public final float getLevelProgress(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int level = this.getLevel(skillType);
        if (level >= skillType.getMaxLevel()) {
            return 1.0f;
        }
        int currentLevelTotalXp = skillType.getTotalXpForLevel(level);
        int nextLevelXp = skillType.getXpForLevel(level + 1);
        int currentXp = this.getXp(skillType);
        int xpIntoLevel = currentXp - currentLevelTotalXp;
        return RangesKt.coerceIn((float)((float)xpIntoLevel / (float)nextLevelXp), (float)0.0f, (float)1.0f);
    }

    public final int getXpToNextLevel(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int level = this.getLevel(skillType);
        if (level >= skillType.getMaxLevel()) {
            return 0;
        }
        return skillType.getXpForLevel(level + 1);
    }

    public final int getXpInCurrentLevel(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        int level = this.getLevel(skillType);
        int totalXpForLevel = skillType.getTotalXpForLevel(level);
        return this.getXp(skillType) - totalXpForLevel;
    }

    public final void setUpgradeTier(@NotNull String upgradeId, int tier) {
        Intrinsics.checkNotNullParameter((Object)upgradeId, (String)"upgradeId");
        this.unlockedUpgrades.put(upgradeId, tier);
    }

    public final int getUpgradeTier(@NotNull String upgradeId) {
        Intrinsics.checkNotNullParameter((Object)upgradeId, (String)"upgradeId");
        Integer n = this.unlockedUpgrades.get(upgradeId);
        return n != null ? n : 0;
    }

    public final void setSkillPoints(@NotNull SkillType skillType, int points) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        this.skillPoints.put(skillType, points);
    }

    public final int getSkillPoints(@NotNull SkillType skillType) {
        Intrinsics.checkNotNullParameter((Object)((Object)skillType), (String)"skillType");
        Integer n = this.skillPoints.get((Object)skillType);
        return n != null ? n : 0;
    }

    public final boolean canUnlockUpgrade(@NotNull SkillUpgrade upgrade) {
        int prereqTier;
        Intrinsics.checkNotNullParameter((Object)upgrade, (String)"upgrade");
        int currentTier = this.getUpgradeTier(upgrade.getId());
        if (currentTier >= upgrade.getMaxTier()) {
            return false;
        }
        int requiredLevel = upgrade.getLevelForTier(currentTier + 1);
        if (this.getLevel(upgrade.getSkillType()) < requiredLevel) {
            return false;
        }
        if (this.getSkillPoints(upgrade.getSkillType()) < upgrade.getPointsPerTier()) {
            return false;
        }
        String prereqId = upgrade.getPrerequisiteId();
        return prereqId == null || (prereqTier = this.getUpgradeTier(prereqId)) >= 1;
    }
}

