/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStatus;
import revive.mod.ReviveTask;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u001d\u00a2\u0006\u0004\b \u0010\u001fJ\r\u0010!\u001a\u00020\f\u00a2\u0006\u0004\b!\u0010\u0003J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\"\u0010\u001cJ\u0019\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060#\u00a2\u0006\u0004\b$\u0010%J\u0019\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130#\u00a2\u0006\u0004\b&\u0010%J5\u0010)\u001a\u00020\f2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060#2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130#\u00a2\u0006\u0004\b)\u0010*R \u0010,\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R \u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010-\u00a8\u0006/"}, d2={"Lrevive/mod/PlayerStateManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lrevive/mod/PlayerStateData;", "getPlayerState", "(Lnet/minecraft/class_3222;)Lrevive/mod/PlayerStateData;", "Ljava/util/UUID;", "uuid", "(Ljava/util/UUID;)Lrevive/mod/PlayerStateData;", "", "updatePlayerName", "(Lnet/minecraft/class_3222;)V", "Lrevive/mod/PlayerStatus;", "recordDeath", "(Lnet/minecraft/class_3222;)Lrevive/mod/PlayerStatus;", "deadPlayerUuid", "Lrevive/mod/ReviveTask;", "startReviveTask", "(Ljava/util/UUID;)Lrevive/mod/ReviveTask;", "getReviveTask", "", "completeRevive", "(Ljava/util/UUID;)Z", "playerUuid", "completeParkour", "(Ljava/util/UUID;)V", "", "getPlayersInPurgatory", "()Ljava/util/List;", "getAlivePlayers", "resetAll", "resetPlayer", "", "getAllStates", "()Ljava/util/Map;", "getAllReviveTasks", "states", "revives", "loadFromSavedData", "(Ljava/util/Map;Ljava/util/Map;)V", "Ljava/util/concurrent/ConcurrentHashMap;", "playerStates", "Ljava/util/concurrent/ConcurrentHashMap;", "pendingRevives", "hardcore-mod"})
@SourceDebugExtension(value={"SMAP\nPlayerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerState.kt\nrevive/mod/PlayerStateManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n777#2:217\n873#2,2:218\n777#2:220\n873#2,2:221\n*S KotlinDebug\n*F\n+ 1 PlayerState.kt\nrevive/mod/PlayerStateManager\n*L\n147#1:217\n147#1:218,2\n154#1:220\n154#1:221,2\n*E\n"})
public final class PlayerStateManager {
    @NotNull
    public static final PlayerStateManager INSTANCE = new PlayerStateManager();
    @NotNull
    private static final ConcurrentHashMap<UUID, PlayerStateData> playerStates = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, ReviveTask> pendingRevives = new ConcurrentHashMap();

    private PlayerStateManager() {
    }

    @NotNull
    public final PlayerStateData getPlayerState(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData playerStateData = playerStates.computeIfAbsent(player.method_5667(), arg_0 -> PlayerStateManager.getPlayerState$lambda$1(arg_0 -> PlayerStateManager.getPlayerState$lambda$0(player, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)playerStateData, (String)"computeIfAbsent(...)");
        return playerStateData;
    }

    @Nullable
    public final PlayerStateData getPlayerState(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return playerStates.get(uuid);
    }

    public final void updatePlayerName(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData playerStateData = this.getPlayerState(player);
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        playerStateData.setPlayerName(string);
    }

    @NotNull
    public final PlayerStatus recordDeath(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = this.getPlayerState(player);
        int n = state.getDeathCount();
        state.setDeathCount(n + 1);
        state.setLastDeathPosition((Triple<Double, Double, Double>)new Triple((Object)player.method_23317(), (Object)player.method_23318(), (Object)player.method_23321()));
        state.setLastDeathDimension(player.method_51469().method_27983().toString());
        state.setStatus(state.getDeathCount() == 1 ? PlayerStatus.IN_PURGATORY : PlayerStatus.SPECTATOR);
        return state.getStatus();
    }

    @NotNull
    public final ReviveTask startReviveTask(@NotNull UUID deadPlayerUuid) {
        Intrinsics.checkNotNullParameter((Object)deadPlayerUuid, (String)"deadPlayerUuid");
        ReviveTask task = new ReviveTask(deadPlayerUuid, false, false, 0L, 14, null);
        ((Map)pendingRevives).put(deadPlayerUuid, task);
        return task;
    }

    @Nullable
    public final ReviveTask getReviveTask(@NotNull UUID deadPlayerUuid) {
        Intrinsics.checkNotNullParameter((Object)deadPlayerUuid, (String)"deadPlayerUuid");
        return pendingRevives.get(deadPlayerUuid);
    }

    public final boolean completeRevive(@NotNull UUID deadPlayerUuid) {
        Intrinsics.checkNotNullParameter((Object)deadPlayerUuid, (String)"deadPlayerUuid");
        ReviveTask reviveTask = pendingRevives.get(deadPlayerUuid);
        if (reviveTask == null) {
            return false;
        }
        ReviveTask task = reviveTask;
        if (!task.isComplete()) {
            return false;
        }
        PlayerStateData playerStateData = playerStates.get(deadPlayerUuid);
        if (playerStateData == null) {
            return false;
        }
        PlayerStateData state = playerStateData;
        state.setStatus(PlayerStatus.ALIVE);
        state.setParkourCompleted(false);
        pendingRevives.remove(deadPlayerUuid);
        return true;
    }

    public final void completeParkour(@NotNull UUID playerUuid) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            PlayerStateData playerStateData = playerStates.get(playerUuid);
            if (playerStateData == null) {
                return;
            }
            PlayerStateData state = playerStateData;
            state.setParkourCompleted(true);
            ReviveTask reviveTask = pendingRevives.get(playerUuid);
            if (reviveTask == null) break block1;
            reviveTask.markParkourComplete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerStateData> getPlayersInPurgatory() {
        void $this$filterTo$iv$iv;
        Collection<PlayerStateData> collection = playerStates.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerStateData it = (PlayerStateData)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == PlayerStatus.IN_PURGATORY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerStateData> getAlivePlayers() {
        void $this$filterTo$iv$iv;
        Collection<PlayerStateData> collection = playerStates.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerStateData it = (PlayerStateData)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == PlayerStatus.ALIVE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void resetAll() {
        playerStates.clear();
        pendingRevives.clear();
    }

    public final void resetPlayer(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        playerStates.remove(uuid);
        pendingRevives.remove(uuid);
    }

    @NotNull
    public final Map<UUID, PlayerStateData> getAllStates() {
        return MapsKt.toMap((Map)playerStates);
    }

    @NotNull
    public final Map<UUID, ReviveTask> getAllReviveTasks() {
        return MapsKt.toMap((Map)pendingRevives);
    }

    public final void loadFromSavedData(@NotNull Map<UUID, PlayerStateData> states, @NotNull Map<UUID, ReviveTask> revives) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        Intrinsics.checkNotNullParameter(revives, (String)"revives");
        playerStates.clear();
        playerStates.putAll(states);
        pendingRevives.clear();
        pendingRevives.putAll(revives);
    }

    private static final PlayerStateData getPlayerState$lambda$0(class_3222 $player, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        UUID uUID = $player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = $player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return new PlayerStateData(uUID, string, null, 0, false, null, null, 0, false, false, false, 2044, null);
    }

    private static final PlayerStateData getPlayerState$lambda$1(Function1 $tmp0, Object p0) {
        return (PlayerStateData)$tmp0.invoke(p0);
    }
}

