/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.ParkourGenerator;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u001f\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u0015\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001c\u0010 \u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\"8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010$R\u001d\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020,0&8\u0006\u00a2\u0006\f\n\u0004\b-\u0010)\u001a\u0004\b.\u0010+R \u00101\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00160/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00103\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106\u00a8\u00067"}, d2={"Lrevive/mod/DimensionManager;", "", "<init>", "()V", "", "isDimensionSetup", "()Z", "Lnet/minecraft/server/MinecraftServer;", "server", "setupDimension", "(Lnet/minecraft/server/MinecraftServer;)Z", "Lnet/minecraft/class_3218;", "getPurgatoryLevel", "(Lnet/minecraft/server/MinecraftServer;)Lnet/minecraft/class_3218;", "Lnet/minecraft/class_3222;", "player", "", "teleportToPurgatory", "(Lnet/minecraft/class_3222;)V", "resetToParkourStart", "teleportToOverworld", "level", "Lnet/minecraft/class_2338;", "pos", "findSafeSpawnLocation", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Lnet/minecraft/class_2338;", "reset", "setup", "setDimensionSetup", "(Z)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "PURGATORY_DIMENSION_ID", "Ljava/lang/String;", "MOD_ID", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_1937;", "PURGATORY_DIMENSION_KEY", "Lnet/minecraft/class_5321;", "getPURGATORY_DIMENSION_KEY", "()Lnet/minecraft/class_5321;", "Lnet/minecraft/class_2874;", "PURGATORY_DIMENSION_TYPE_KEY", "getPURGATORY_DIMENSION_TYPE_KEY", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "parkourStartPositions", "Ljava/util/concurrent/ConcurrentHashMap;", "purgatorySpawnPoint", "Lnet/minecraft/class_2338;", "dimensionSetup", "Z", "hardcore-mod"})
public final class DimensionManager {
    @NotNull
    public static final DimensionManager INSTANCE = new DimensionManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    public static final String PURGATORY_DIMENSION_ID = "hardcore-mod:purgatory";
    @NotNull
    public static final String MOD_ID = "hardcore-mod";
    @NotNull
    private static final class_5321<class_1937> PURGATORY_DIMENSION_KEY;
    @NotNull
    private static final class_5321<class_2874> PURGATORY_DIMENSION_TYPE_KEY;
    @NotNull
    private static final ConcurrentHashMap<UUID, class_2338> parkourStartPositions;
    @NotNull
    private static class_2338 purgatorySpawnPoint;
    private static boolean dimensionSetup;

    private DimensionManager() {
    }

    @NotNull
    public final class_5321<class_1937> getPURGATORY_DIMENSION_KEY() {
        return PURGATORY_DIMENSION_KEY;
    }

    @NotNull
    public final class_5321<class_2874> getPURGATORY_DIMENSION_TYPE_KEY() {
        return PURGATORY_DIMENSION_TYPE_KEY;
    }

    public final boolean isDimensionSetup() {
        return dimensionSetup;
    }

    public final boolean setupDimension(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        logger.info("Setting up purgatory dimension...");
        class_3218 purgatoryLevel = this.getPurgatoryLevel(server);
        if (purgatoryLevel == null) {
            logger.error("Failed to get purgatory dimension! Make sure dimension is registered.");
            return false;
        }
        ParkourGenerator.ParkourVariant parkourVariant = ParkourGenerator.INSTANCE.getRandomParkour();
        purgatorySpawnPoint = ParkourGenerator.INSTANCE.generateParkour(purgatoryLevel, parkourVariant);
        dimensionSetup = true;
        logger.info("Purgatory dimension setup complete! Spawn point: " + purgatorySpawnPoint);
        return true;
    }

    @Nullable
    public final class_3218 getPurgatoryLevel(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return server.method_3847(PURGATORY_DIMENSION_KEY);
    }

    public final void teleportToPurgatory(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        class_3218 purgatoryLevel = this.getPurgatoryLevel(server);
        if (purgatoryLevel == null) {
            logger.error("Cannot teleport to purgatory - dimension not found!");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cError: Purgatory dimension not found! Admin must run /hardcore setup."));
            return;
        }
        if (!dimensionSetup) {
            logger.warn("Dimension not set up yet, using default spawn");
        }
        class_2338 class_23382 = purgatorySpawnPoint.method_10069(2, 1, 2);
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"offset(...)");
        class_2338 spawnOnPlatform = class_23382;
        ((Map)parkourStartPositions).put(player.method_5667(), spawnOnPlatform);
        player.method_48105(purgatoryLevel, (double)spawnOnPlatform.method_10263() + 0.5, (double)spawnOnPlatform.method_10264(), (double)spawnOnPlatform.method_10260() + 0.5, SetsKt.emptySet(), player.method_36454(), player.method_36455(), false);
        player.method_18799(class_243.field_1353);
        player.field_6017 = 0.0;
        player.method_5646();
        logger.info("Teleported " + player.method_7334().name() + " to purgatory at " + spawnOnPlatform);
    }

    public final void resetToParkourStart(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_2338 class_23382 = parkourStartPositions.get(player.method_5667());
        if (class_23382 == null) {
            class_2338 class_23383 = purgatorySpawnPoint.method_10069(2, 1, 2);
            class_23382 = class_23383;
            Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"offset(...)");
        }
        class_2338 startPos = class_23382;
        player.method_5859((double)startPos.method_10263() + 0.5, (double)startPos.method_10264(), (double)startPos.method_10260() + 0.5);
        player.method_18799(class_243.field_1353);
        player.field_6017 = 0.0;
        player.method_5646();
        logger.info("Reset " + player.method_7334().name() + " to parkour start at " + startPos);
    }

    public final void teleportToOverworld(@NotNull class_3222 player) {
        class_2338 class_23382;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        class_3218 class_32182 = server.method_3847(class_1937.field_25179);
        if (class_32182 == null) {
            return;
        }
        class_3218 overworld = class_32182;
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        Triple<Double, Double, Double> lastDeathPos = state.getLastDeathPosition();
        if (lastDeathPos != null) {
            class_23382 = new class_2338((int)((Number)lastDeathPos.getFirst()).doubleValue(), (int)((Number)lastDeathPos.getSecond()).doubleValue(), (int)((Number)lastDeathPos.getThird()).doubleValue());
        } else {
            class_2338 class_23383 = overworld.method_74854().method_74897();
            Intrinsics.checkNotNull((Object)class_23383);
            class_23382 = class_23383;
        }
        class_2338 targetPos = class_23382;
        class_2338 safePos = this.findSafeSpawnLocation(overworld, targetPos);
        player.method_48105(overworld, (double)safePos.method_10263() + 0.5, (double)safePos.method_10264(), (double)safePos.method_10260() + 0.5, SetsKt.emptySet(), player.method_36454(), player.method_36455(), false);
        parkourStartPositions.remove(player.method_5667());
        logger.info("Teleported " + player.method_7334().name() + " back to overworld at " + safePos);
    }

    private final class_2338 findSafeSpawnLocation(class_3218 level, class_2338 pos) {
        class_2338 checkPos = pos;
        while (!level.method_8320(checkPos).method_26215() && checkPos.method_10264() < level.method_31600()) {
            Intrinsics.checkNotNullExpressionValue((Object)checkPos.method_10084(), (String)"above(...)");
        }
        class_2338 class_23382 = checkPos.method_10074();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"below(...)");
        class_2338 groundPos = class_23382;
        while (level.method_8320(groundPos).method_26215() && groundPos.method_10264() > level.method_31607()) {
            Intrinsics.checkNotNullExpressionValue((Object)groundPos.method_10074(), (String)"below(...)");
        }
        class_2338 class_23383 = groundPos.method_10084();
        Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"above(...)");
        return class_23383;
    }

    public final void reset() {
        dimensionSetup = false;
        parkourStartPositions.clear();
        purgatorySpawnPoint = new class_2338(0, 100, 0);
    }

    public final void setDimensionSetup(boolean setup) {
        dimensionSetup = setup;
    }

    static {
        class_5321 class_53212 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"purgatory"));
        Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"create(...)");
        PURGATORY_DIMENSION_KEY = class_53212;
        class_5321 class_53213 = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"purgatory_type"));
        Intrinsics.checkNotNullExpressionValue((Object)class_53213, (String)"create(...)");
        PURGATORY_DIMENSION_TYPE_KEY = class_53213;
        parkourStartPositions = new ConcurrentHashMap();
        purgatorySpawnPoint = new class_2338(0, 100, 0);
    }
}

