/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.skills;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.skills.PlayerSkillData;
import revive.mod.skills.SkillDataManager;
import revive.mod.skills.SkillManager;
import revive.mod.skills.SkillType;
import revive.mod.skills.SkillUpgrade;
import revive.mod.skills.SkillUpgrades;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0012\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000fJ%\u0010\u0015\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0013J%\u0010\u0017\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0013R\u001c\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lrevive/mod/skills/SkillCommands;", "", "<init>", "()V", "", "register", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "registerCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "showSkillsOverview", "(Lcom/mojang/brigadier/context/CommandContext;)I", "", "skillName", "showSkillInfo", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)I", "showAllUpgrades", "showSkillUpgrades", "upgradeId", "unlockUpgrade", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "hardcore-mod"})
@SourceDebugExtension(value={"SMAP\nSkillCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkillCommands.kt\nrevive/mod/skills/SkillCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1586#2:372\n1661#2,3:373\n1586#2:376\n1661#2,3:377\n1586#2:380\n1661#2,3:381\n*S KotlinDebug\n*F\n+ 1 SkillCommands.kt\nrevive/mod/skills/SkillCommands\n*L\n41#1:372\n41#1:373,3\n57#1:376\n57#1:377,3\n72#1:380\n72#1:381,3\n*E\n"})
public final class SkillCommands {
    @NotNull
    public static final SkillCommands INSTANCE = new SkillCommands();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod-skills");

    private SkillCommands() {
    }

    public final void register() {
        CommandRegistrationCallback.EVENT.register(SkillCommands::register$lambda$0);
    }

    private final void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skills").executes(SkillCommands::registerCommands$lambda$0)).then(class_2170.method_9247((String)"list").executes(SkillCommands::registerCommands$lambda$1))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"skill", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(SkillCommands::registerCommands$lambda$2).executes(SkillCommands::registerCommands$lambda$3)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"upgrades").executes(SkillCommands::registerCommands$lambda$4)).then(class_2170.method_9244((String)"skill", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(SkillCommands::registerCommands$lambda$5).executes(SkillCommands::registerCommands$lambda$6)))).then(class_2170.method_9247((String)"unlock").then(class_2170.method_9244((String)"upgrade", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(SkillCommands::registerCommands$lambda$7).executes(SkillCommands::registerCommands$lambda$8))));
        logger.info("Registered /skills command");
    }

    private final int showSkillsOverview(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"));
            return 0;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        source.method_9226(SkillCommands::showSkillsOverview$lambda$0, false);
        source.method_9226(SkillCommands::showSkillsOverview$lambda$1, false);
        for (SkillType skillType : SkillType.getEntries()) {
            int level = skillData.getLevel(skillType);
            int xp = skillData.getXp(skillType);
            int xpToNext = skillData.getXpToNextLevel(skillType);
            int xpInLevel = skillData.getXpInCurrentLevel(skillType);
            float progress = skillData.getLevelProgress(skillType);
            int points = skillData.getSkillPoints(skillType);
            int barLength = 20;
            int filledBars = (int)(progress * (float)barLength);
            int emptyBars = barLength - filledBars;
            String progressBar = "\u00a7a" + StringsKt.repeat((CharSequence)"\u25ae", (int)filledBars) + "\u00a77" + StringsKt.repeat((CharSequence)"\u25af", (int)emptyBars);
            source.method_9226(() -> SkillCommands.showSkillsOverview$lambda$2(skillType, level), false);
            source.method_9226(() -> SkillCommands.showSkillsOverview$lambda$3(progressBar, xpInLevel, xpToNext), false);
            if (points <= 0) continue;
            source.method_9226(() -> SkillCommands.showSkillsOverview$lambda$4(points), false);
        }
        source.method_9226(SkillCommands::showSkillsOverview$lambda$5, false);
        source.method_9226(SkillCommands::showSkillsOverview$lambda$6, false);
        source.method_9226(SkillCommands::showSkillsOverview$lambda$7, false);
        return 1;
    }

    private final int showSkillInfo(CommandContext<class_2168> context, String skillName) {
        SkillType skillType;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"));
            return 0;
        }
        try {
            String string = skillName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            skillType = SkillType.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cUnknown skill: " + skillName)));
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a77Available: " + CollectionsKt.joinToString$default((Iterable)((Iterable)SkillType.getEntries()), (CharSequence)", ", null, null, (int)0, null, SkillCommands::showSkillInfo$lambda$0, (int)30, null))));
            return 0;
        }
        SkillType skillType2 = skillType;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        int level = skillData.getLevel(skillType2);
        int xp = skillData.getXp(skillType2);
        int xpToNext = skillData.getXpToNextLevel(skillType2);
        int xpInLevel = skillData.getXpInCurrentLevel(skillType2);
        int points = skillData.getSkillPoints(skillType2);
        int totalXpForNext = skillType2.getTotalXpForLevel(level + 1);
        source.method_9226(() -> SkillCommands.showSkillInfo$lambda$1(skillType2), false);
        source.method_9226(() -> SkillCommands.showSkillInfo$lambda$2(skillType2), false);
        source.method_9226(SkillCommands::showSkillInfo$lambda$3, false);
        source.method_9226(() -> SkillCommands.showSkillInfo$lambda$4(skillType2, level), false);
        source.method_9226(() -> SkillCommands.showSkillInfo$lambda$5(xp), false);
        source.method_9226(() -> SkillCommands.showSkillInfo$lambda$6(xpInLevel, xpToNext), false);
        source.method_9226(() -> SkillCommands.showSkillInfo$lambda$7(points), false);
        source.method_9226(SkillCommands::showSkillInfo$lambda$8, false);
        source.method_9226(SkillCommands::showSkillInfo$lambda$9, false);
        List<SkillUpgrade> upgrades = SkillUpgrades.INSTANCE.getUpgradesForSkill(skillType2);
        boolean hasUnlocked = false;
        for (SkillUpgrade upgrade : upgrades) {
            int tier = skillData.getUpgradeTier(upgrade.getId());
            if (tier <= 0) continue;
            hasUnlocked = true;
            int effect = (int)(upgrade.getEffectAtTier(tier) * (float)100);
            source.method_9226(() -> SkillCommands.showSkillInfo$lambda$10(upgrade, tier, effect), false);
        }
        if (!hasUnlocked) {
            source.method_9226(SkillCommands::showSkillInfo$lambda$11, false);
        }
        return 1;
    }

    private final int showAllUpgrades(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(SkillCommands::showAllUpgrades$lambda$0, false);
        source.method_9226(SkillCommands::showAllUpgrades$lambda$1, false);
        source.method_9226(SkillCommands::showAllUpgrades$lambda$2, false);
        for (SkillType skillType : SkillType.getEntries()) {
            source.method_9226(() -> SkillCommands.showAllUpgrades$lambda$3(skillType), false);
        }
        return 1;
    }

    private final int showSkillUpgrades(CommandContext<class_2168> context, String skillName) {
        SkillType skillType;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"));
            return 0;
        }
        try {
            String string = skillName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            skillType = SkillType.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cUnknown skill: " + skillName)));
            return 0;
        }
        SkillType skillType2 = skillType;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        int currentLevel = skillData.getLevel(skillType2);
        int points = skillData.getSkillPoints(skillType2);
        source.method_9226(() -> SkillCommands.showSkillUpgrades$lambda$0(skillType2), false);
        source.method_9226(() -> SkillCommands.showSkillUpgrades$lambda$1(points), false);
        source.method_9226(SkillCommands::showSkillUpgrades$lambda$2, false);
        List<SkillUpgrade> upgrades = SkillUpgrades.INSTANCE.getUpgradesForSkill(skillType2);
        for (SkillUpgrade upgrade : upgrades) {
            int tier = skillData.getUpgradeTier(upgrade.getId());
            boolean canUnlock = skillData.canUnlockUpgrade(upgrade);
            int nextTier = tier + 1;
            int requiredLevel = upgrade.getLevelForTier(nextTier);
            String statusColor = tier >= upgrade.getMaxTier() ? "\u00a72" : (canUnlock ? "\u00a7a" : "\u00a77");
            String statusSymbol = tier >= upgrade.getMaxTier() ? "\u2605" : (tier > 0 ? "\u2713" : (canUnlock ? "\u25b6" : "\u2717"));
            source.method_9226(() -> SkillCommands.showSkillUpgrades$lambda$3(statusColor, statusSymbol, upgrade, tier), false);
            if (tier >= upgrade.getMaxTier()) continue;
            int nextEffect = (int)(upgrade.getEffectAtTier(nextTier) * (float)100);
            source.method_9226(() -> SkillCommands.showSkillUpgrades$lambda$4(upgrade, nextEffect), false);
            source.method_9226(() -> SkillCommands.showSkillUpgrades$lambda$5(requiredLevel, upgrade), false);
            if (upgrade.getPrerequisiteId() == null || skillData.getUpgradeTier(upgrade.getPrerequisiteId()) >= 1) continue;
            SkillUpgrade prereq = SkillUpgrades.INSTANCE.getUpgradeById(upgrade.getPrerequisiteId());
            source.method_9226(() -> SkillCommands.showSkillUpgrades$lambda$6(prereq, upgrade), false);
        }
        source.method_9226(SkillCommands::showSkillUpgrades$lambda$7, false);
        source.method_9226(SkillCommands::showSkillUpgrades$lambda$8, false);
        return 1;
    }

    private final int unlockUpgrade(CommandContext<class_2168> context, String upgradeId) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"));
            return 0;
        }
        SkillUpgrade upgrade = SkillUpgrades.INSTANCE.getUpgradeById(upgradeId);
        if (upgrade == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cUnknown upgrade: " + upgradeId)));
            return 0;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_7334().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        PlayerSkillData skillData = SkillDataManager.INSTANCE.getPlayerData(uUID, string);
        int currentTier = skillData.getUpgradeTier(upgradeId);
        if (currentTier >= upgrade.getMaxTier()) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + upgrade.getName() + " is already at max tier!")));
            return 0;
        }
        if (!skillData.canUnlockUpgrade(upgrade)) {
            int nextTier = currentTier + 1;
            int requiredLevel = upgrade.getLevelForTier(nextTier);
            int currentLevel = skillData.getLevel(upgrade.getSkillType());
            int points = skillData.getSkillPoints(upgrade.getSkillType());
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cCannot unlock " + upgrade.getName() + "!")));
            if (currentLevel < requiredLevel) {
                source.method_9213((class_2561)class_2561.method_43470((String)("\u00a77- Need " + upgrade.getSkillType().getDisplayName() + " level " + requiredLevel + " (you have " + currentLevel + ")")));
            }
            if (points < upgrade.getPointsPerTier()) {
                source.method_9213((class_2561)class_2561.method_43470((String)("\u00a77- Need " + upgrade.getPointsPerTier() + " skill points (you have " + points + ")")));
            }
            if (upgrade.getPrerequisiteId() != null && skillData.getUpgradeTier(upgrade.getPrerequisiteId()) < 1) {
                SkillUpgrade prereq = SkillUpgrades.INSTANCE.getUpgradeById(upgrade.getPrerequisiteId());
                Object object = prereq;
                if (object == null || (object = ((SkillUpgrade)object).getName()) == null) {
                    object = upgrade.getPrerequisiteId();
                }
                source.method_9213((class_2561)class_2561.method_43470((String)("\u00a77- Need to unlock " + (String)object + " first")));
            }
            return 0;
        }
        boolean success = SkillManager.INSTANCE.tryUnlockUpgrade(player, upgradeId);
        return success ? 1 : 0;
    }

    private static final void register$lambda$0(CommandDispatcher dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        INSTANCE.registerCommands((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final int registerCommands$lambda$0(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.showSkillsOverview((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.showSkillsOverview((CommandContext<class_2168>)context);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture registerCommands$lambda$2(CommandContext context, SuggestionsBuilder builder) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)SkillType.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SkillType skillType = (SkillType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        return class_2172.method_9265((Iterable)((List)destination$iv$iv), (SuggestionsBuilder)builder);
    }

    private static final int registerCommands$lambda$3(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String string = StringArgumentType.getString((CommandContext)context, (String)"skill");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.showSkillInfo((CommandContext<class_2168>)context, string);
    }

    private static final int registerCommands$lambda$4(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.showAllUpgrades((CommandContext<class_2168>)context);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture registerCommands$lambda$5(CommandContext context, SuggestionsBuilder builder) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)SkillType.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SkillType skillType = (SkillType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        return class_2172.method_9265((Iterable)((List)destination$iv$iv), (SuggestionsBuilder)builder);
    }

    private static final int registerCommands$lambda$6(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String string = StringArgumentType.getString((CommandContext)context, (String)"skill");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.showSkillUpgrades((CommandContext<class_2168>)context, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture registerCommands$lambda$7(CommandContext context, SuggestionsBuilder builder) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = SkillUpgrades.INSTANCE.getAllUpgrades();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SkillUpgrade skillUpgrade = (SkillUpgrade)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return class_2172.method_9265((Iterable)((List)destination$iv$iv), (SuggestionsBuilder)builder);
    }

    private static final int registerCommands$lambda$8(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String string = StringArgumentType.getString((CommandContext)context, (String)"upgrade");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.unlockUpgrade((CommandContext<class_2168>)context, string);
    }

    private static final class_2561 showSkillsOverview$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a76\u00a7l=== Your Skills ===");
    }

    private static final class_2561 showSkillsOverview$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"");
    }

    private static final class_2561 showSkillsOverview$lambda$2(SkillType $skillType, int $level) {
        return (class_2561)class_2561.method_43470((String)($skillType.getColor() + "\u00a7l" + $skillType.getDisplayName() + " \u00a7fLv." + $level));
    }

    private static final class_2561 showSkillsOverview$lambda$3(String $progressBar, int $xpInLevel, int $xpToNext) {
        return (class_2561)class_2561.method_43470((String)("  " + $progressBar + " \u00a77" + $xpInLevel + "/" + $xpToNext + " XP"));
    }

    private static final class_2561 showSkillsOverview$lambda$4(int $points) {
        return (class_2561)class_2561.method_43470((String)("  \u00a7a" + $points + " skill point(s) available!"));
    }

    private static final class_2561 showSkillsOverview$lambda$5() {
        return (class_2561)class_2561.method_43470((String)"");
    }

    private static final class_2561 showSkillsOverview$lambda$6() {
        return (class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7f/skills info <skill>\u00a77 for details");
    }

    private static final class_2561 showSkillsOverview$lambda$7() {
        return (class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7f/skills upgrades <skill>\u00a77 to see upgrades");
    }

    private static final CharSequence showSkillInfo$lambda$0(SkillType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        String string = it.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final class_2561 showSkillInfo$lambda$1(SkillType $skillType) {
        return (class_2561)class_2561.method_43470((String)("\u00a76\u00a7l=== " + $skillType.getDisplayName() + " ==="));
    }

    private static final class_2561 showSkillInfo$lambda$2(SkillType $skillType) {
        return (class_2561)class_2561.method_43470((String)("\u00a77" + $skillType.getDescription()));
    }

    private static final class_2561 showSkillInfo$lambda$3() {
        return (class_2561)class_2561.method_43470((String)"");
    }

    private static final class_2561 showSkillInfo$lambda$4(SkillType $skillType, int $level) {
        return (class_2561)class_2561.method_43470((String)($skillType.getColor() + "Level: \u00a7f" + $level + "/" + $skillType.getMaxLevel()));
    }

    private static final class_2561 showSkillInfo$lambda$5(int $xp) {
        return (class_2561)class_2561.method_43470((String)("\u00a7eTotal XP: \u00a7f" + $xp));
    }

    private static final class_2561 showSkillInfo$lambda$6(int $xpInLevel, int $xpToNext) {
        return (class_2561)class_2561.method_43470((String)("\u00a7eProgress: \u00a7f" + $xpInLevel + "/" + $xpToNext + " XP"));
    }

    private static final class_2561 showSkillInfo$lambda$7(int $points) {
        return (class_2561)class_2561.method_43470((String)("\u00a7aSkill Points: \u00a7f" + $points));
    }

    private static final class_2561 showSkillInfo$lambda$8() {
        return (class_2561)class_2561.method_43470((String)"");
    }

    private static final class_2561 showSkillInfo$lambda$9() {
        return (class_2561)class_2561.method_43470((String)"\u00a76Unlocked Upgrades:");
    }

    private static final class_2561 showSkillInfo$lambda$10(SkillUpgrade $upgrade, int $tier, int $effect) {
        return (class_2561)class_2561.method_43470((String)("\u00a7a  \u2713 " + $upgrade.getName() + " \u00a77Tier " + $tier + "/" + $upgrade.getMaxTier() + " (+" + $effect + "%)"));
    }

    private static final class_2561 showSkillInfo$lambda$11() {
        return (class_2561)class_2561.method_43470((String)"\u00a77  No upgrades unlocked yet");
    }

    private static final class_2561 showAllUpgrades$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a76\u00a7l=== Skill Upgrades ===");
    }

    private static final class_2561 showAllUpgrades$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7f/skills upgrades <skill>\u00a77 to see upgrades for a specific skill");
    }

    private static final class_2561 showAllUpgrades$lambda$2() {
        return (class_2561)class_2561.method_43470((String)"");
    }

    private static final class_2561 showAllUpgrades$lambda$3(SkillType $skillType) {
        return (class_2561)class_2561.method_43470((String)($skillType.getColor() + $skillType.getDisplayName() + ": \u00a77" + SkillUpgrades.INSTANCE.getUpgradesForSkill($skillType).size() + " upgrades"));
    }

    private static final class_2561 showSkillUpgrades$lambda$0(SkillType $skillType) {
        return (class_2561)class_2561.method_43470((String)("\u00a76\u00a7l=== " + $skillType.getDisplayName() + " Upgrades ==="));
    }

    private static final class_2561 showSkillUpgrades$lambda$1(int $points) {
        return (class_2561)class_2561.method_43470((String)("\u00a7aAvailable Points: \u00a7f" + $points));
    }

    private static final class_2561 showSkillUpgrades$lambda$2() {
        return (class_2561)class_2561.method_43470((String)"");
    }

    private static final class_2561 showSkillUpgrades$lambda$3(String $statusColor, String $statusSymbol, SkillUpgrade $upgrade, int $tier) {
        return (class_2561)class_2561.method_43470((String)($statusColor + $statusSymbol + " " + $upgrade.getName() + " \u00a77[" + $tier + "/" + $upgrade.getMaxTier() + "]"));
    }

    private static final class_2561 showSkillUpgrades$lambda$4(SkillUpgrade $upgrade, int $nextEffect) {
        return (class_2561)class_2561.method_43470((String)("\u00a77  " + $upgrade.getDescription() + " (+" + $nextEffect + "%)"));
    }

    private static final class_2561 showSkillUpgrades$lambda$5(int $requiredLevel, SkillUpgrade $upgrade) {
        return (class_2561)class_2561.method_43470((String)("\u00a77  Requires: Lv." + $requiredLevel + ", " + $upgrade.getPointsPerTier() + " points"));
    }

    private static final class_2561 showSkillUpgrades$lambda$6(SkillUpgrade $prereq, SkillUpgrade $upgrade) {
        Object object = $prereq;
        if (object == null || (object = ((SkillUpgrade)object).getName()) == null) {
            object = $upgrade.getPrerequisiteId();
        }
        return (class_2561)class_2561.method_43470((String)("\u00a7c  Needs: " + (String)object));
    }

    private static final class_2561 showSkillUpgrades$lambda$7() {
        return (class_2561)class_2561.method_43470((String)"");
    }

    private static final class_2561 showSkillUpgrades$lambda$8() {
        return (class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7f/skills unlock <upgrade_id>\u00a77 to unlock");
    }
}

