/*
 * Decompiled with CFR 0.152.
 */
package revive.mod.mixin;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1734;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8566;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import revive.mod.GameSessionManager;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.ReviveRecipeManager;

@Mixin(value={class_1734.class})
public class CraftingMixin {
    @Unique
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"hardcore-mod-crafting");
    @Shadow
    @Final
    private class_8566 field_7870;
    @Shadow
    @Final
    private class_1657 field_7868;

    @Inject(at={@At(value="HEAD")}, method={"method_7667"})
    private void onCraftingResult(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (!GameSessionManager.INSTANCE.isGameActive()) {
            return;
        }
        ArrayList<class_1799> craftingItems = new ArrayList<class_1799>();
        LOGGER.info("Checking crafting grid with {} slots", (Object)this.field_7870.method_5439());
        for (int i = 0; i < this.field_7870.method_5439(); ++i) {
            class_1799 item = this.field_7870.method_5438(i);
            craftingItems.add(item);
            if (item.method_7960()) continue;
            LOGGER.info("Slot {}: {} x{}", new Object[]{i, item.method_7909().toString(), item.method_7947()});
        }
        UUID deadPlayerUUID = ReviveRecipeManager.INSTANCE.checkReviveRecipe(craftingItems);
        if (deadPlayerUUID != null) {
            LOGGER.info("Valid revive recipe found for player UUID: {}", (Object)deadPlayerUUID);
            PlayerStateData deadPlayerState = PlayerStateManager.INSTANCE.getPlayerState(deadPlayerUUID);
            if (deadPlayerState != null) {
                class_1799 reviveTotem = ReviveRecipeManager.INSTANCE.createReviveTotem(deadPlayerUUID, deadPlayerState.getPlayerName());
                stack.method_7939(0);
                if (!serverPlayer.method_31548().method_7394(reviveTotem)) {
                    serverPlayer.method_7328(reviveTotem, false);
                }
                for (int i = 0; i < this.field_7870.method_5439(); ++i) {
                    this.field_7870.method_5447(i, class_1799.field_8037);
                }
                serverPlayer.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7lRevive Totem crafted!"));
                serverPlayer.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eUse it (right-click) to activate the revival!"));
                LOGGER.info("Revive totem given to {}", (Object)serverPlayer.method_7334().name());
            }
        }
    }
}

