/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_12099;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.ChallengeManager;
import revive.mod.DeathHandler;
import revive.mod.DimensionManager;
import revive.mod.GameSessionManager;
import revive.mod.GraveManager;
import revive.mod.NetworkHandler;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.PlayerStatus;
import revive.mod.RestrictedSpectatorManager;
import revive.mod.ReviveCraftingHandler;
import revive.mod.ReviveTask;
import revive.mod.SessionStats;
import revive.mod.discord.DiscordNotifier;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001d\u0010\u0011\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u001d\u0010\u0012\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000fJ%\u0010\u0015\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u0017\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J-\u0010\u0019\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000fJ\u001d\u0010\u001c\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u000fJ\u001d\u0010\u001d\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u000fJ\u001d\u0010\u001e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u000fJ\u001d\u0010\u001f\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u000fJ\u001d\u0010 \u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b \u0010\u000fJ\u001d\u0010!\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b!\u0010\u000fJ\u001d\u0010\"\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b\"\u0010\u000fJ\u001d\u0010#\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b#\u0010\u000fJ\u001d\u0010$\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b$\u0010\u000fJ\u001d\u0010%\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b%\u0010\u000fJ\u001d\u0010&\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b&\u0010\u000fJ\u001d\u0010'\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b'\u0010\u000fJ\u001d\u0010(\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b(\u0010\u000fJ\u001d\u0010)\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a2\u0006\u0004\b)\u0010\u000fJ%\u0010,\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\b,\u0010-R\u001c\u00100\u001a\n /*\u0004\u0018\u00010.0.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00062"}, d2={"Lrevive/mod/HardcoreCommands;", "", "<init>", "()V", "", "register", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "registerCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "reviveHelpCommand", "(Lcom/mojang/brigadier/context/CommandContext;)I", "setupCommand", "resetCommand", "statusCommand", "Lnet/minecraft/class_3222;", "target", "forceReviveCommand", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;)I", "resetPlayerCommand", "amount", "restoreHeartsCommand", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;I)I", "regenerateParkourCommand", "startGameCommand", "stopGameCommand", "pauseGameCommand", "resumeGameCommand", "showTimeCommand", "gravesCommand", "craftCommand", "challengeSetupCommand", "challengeAcceptCommand", "challengeDeclineCommand", "discordEnableCommand", "discordDisableCommand", "discordStatusCommand", "discordTestCommand", "", "url", "discordSetUrlCommand", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)I", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "hardcore-mod"})
@SourceDebugExtension(value={"SMAP\nHardcoreCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HardcoreCommands.kt\nrevive/mod/HardcoreCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,737:1\n1915#2,2:738\n1915#2,2:740\n*S KotlinDebug\n*F\n+ 1 HardcoreCommands.kt\nrevive/mod/HardcoreCommands\n*L\n261#1:738,2\n419#1:740,2\n*E\n"})
public final class HardcoreCommands {
    @NotNull
    public static final HardcoreCommands INSTANCE = new HardcoreCommands();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");

    private HardcoreCommands() {
    }

    public final void register() {
        CommandRegistrationCallback.EVENT.register(HardcoreCommands::register$lambda$0);
    }

    private final void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hardcore").requires(HardcoreCommands::registerCommands$lambda$0)).then(class_2170.method_9247((String)"setup").executes(HardcoreCommands::registerCommands$lambda$1))).then(class_2170.method_9247((String)"reset").executes(HardcoreCommands::registerCommands$lambda$2))).then(class_2170.method_9247((String)"status").executes(HardcoreCommands::registerCommands$lambda$3))).then(class_2170.method_9247((String)"revive").then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).executes(HardcoreCommands::registerCommands$lambda$4)))).then(class_2170.method_9247((String)"resetplayer").then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).executes(HardcoreCommands::registerCommands$lambda$5)))).then(class_2170.method_9247((String)"regenerate").executes(HardcoreCommands::registerCommands$lambda$6))).then(class_2170.method_9247((String)"restorehearts").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)10))).executes(HardcoreCommands::registerCommands$lambda$7))).executes(HardcoreCommands::registerCommands$lambda$8)))).then(class_2170.method_9247((String)"challengesetup").executes(HardcoreCommands::registerCommands$lambda$9))).then(class_2170.method_9247((String)"start").executes(HardcoreCommands::registerCommands$lambda$10))).then(class_2170.method_9247((String)"stop").executes(HardcoreCommands::registerCommands$lambda$11))).then(class_2170.method_9247((String)"pause").executes(HardcoreCommands::registerCommands$lambda$12))).then(class_2170.method_9247((String)"resume").executes(HardcoreCommands::registerCommands$lambda$13))).then(class_2170.method_9247((String)"time").executes(HardcoreCommands::registerCommands$lambda$14))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"discord").then(class_2170.method_9247((String)"enable").executes(HardcoreCommands::registerCommands$lambda$15))).then(class_2170.method_9247((String)"disable").executes(HardcoreCommands::registerCommands$lambda$16))).then(class_2170.method_9247((String)"status").executes(HardcoreCommands::registerCommands$lambda$17))).then(class_2170.method_9247((String)"test").executes(HardcoreCommands::registerCommands$lambda$18))).then(class_2170.method_9247((String)"seturl").then(class_2170.method_9244((String)"url", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(HardcoreCommands::registerCommands$lambda$19))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"craft").requires(HardcoreCommands::registerCommands$lambda$20)).executes(HardcoreCommands::registerCommands$lambda$21)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"revive").then(class_2170.method_9247((String)"craft").executes(HardcoreCommands::registerCommands$lambda$22))).then(class_2170.method_9247((String)"help").executes(HardcoreCommands::registerCommands$lambda$23))).then(class_2170.method_9247((String)"graves").executes(HardcoreCommands::registerCommands$lambda$24))).executes(HardcoreCommands::registerCommands$lambda$25));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"challenge").then(class_2170.method_9247((String)"accept").executes(HardcoreCommands::registerCommands$lambda$26))).then(class_2170.method_9247((String)"decline").executes(HardcoreCommands::registerCommands$lambda$27)));
        logger.info("Registered /hardcore, /revive, and /challenge commands");
    }

    private final int reviveHelpCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$0, false);
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$1, false);
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$2, false);
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$3, false);
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$4, false);
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$5, false);
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$6, false);
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$7, false);
        source.method_9226(HardcoreCommands::reviveHelpCommand$lambda$8, false);
        return 1;
    }

    private final int setupCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        source.method_9226(HardcoreCommands::setupCommand$lambda$0, true);
        boolean success = DimensionManager.INSTANCE.setupDimension(server);
        if (success) {
            source.method_9226(HardcoreCommands::setupCommand$lambda$1, true);
            source.method_9226(HardcoreCommands::setupCommand$lambda$2, false);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to setup purgatory dimension!"));
        source.method_9213((class_2561)class_2561.method_43470((String)"\u00a77Make sure the dimension is properly registered."));
        return 0;
    }

    private final int resetCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        PlayerStateManager.INSTANCE.resetAll();
        DimensionManager.INSTANCE.reset();
        RestrictedSpectatorManager.INSTANCE.reset();
        source.method_9226(HardcoreCommands::resetCommand$lambda$0, true);
        source.method_9226(HardcoreCommands::resetCommand$lambda$1, false);
        source.method_9226(HardcoreCommands::resetCommand$lambda$2, false);
        return 1;
    }

    private final int statusCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        source.method_9226(HardcoreCommands::statusCommand$lambda$0, false);
        String dimensionStatus = DimensionManager.INSTANCE.isDimensionSetup() ? "\u00a7aSetup" : "\u00a7cNot Setup";
        source.method_9226(() -> HardcoreCommands.statusCommand$lambda$1(dimensionStatus), false);
        source.method_9226(HardcoreCommands::statusCommand$lambda$2, false);
        source.method_9226(HardcoreCommands::statusCommand$lambda$3, false);
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
            String statusColor = switch (WhenMappings.$EnumSwitchMapping$0[state.getStatus().ordinal()]) {
                case 1 -> "\u00a7a";
                case 2 -> "\u00a7e";
                case 3 -> "\u00a7c";
                default -> throw new NoWhenBranchMatchedException();
            };
            String statusText = statusColor + state.getStatus();
            String deathCount = "\u00a77(Deaths: " + state.getDeathCount() + ")";
            source.method_9226(() -> HardcoreCommands.statusCommand$lambda$4$0(player, statusText, deathCount), false);
            if (state.getStatus() != PlayerStatus.IN_PURGATORY) continue;
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            ReviveTask task = PlayerStateManager.INSTANCE.getReviveTask(uUID);
            if (task == null) continue;
            String parkourStatus = task.getParkourCompleted() ? "\u00a7a\u2713" : "\u00a7c\u2717";
            String craftingStatus = task.getCraftingCompleted() ? "\u00a7a\u2713" : "\u00a7c\u2717";
            source.method_9226(() -> HardcoreCommands.statusCommand$lambda$4$1(parkourStatus, craftingStatus), false);
        }
        return 1;
    }

    private final int forceReviveCommand(CommandContext<class_2168> context, class_3222 target) {
        class_2168 source = (class_2168)context.getSource();
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(target);
        if (state.getStatus() == PlayerStatus.ALIVE) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + target.method_7334().name() + " is already alive!")));
            return 0;
        }
        state.setStatus(PlayerStatus.ALIVE);
        state.setParkourCompleted(false);
        DimensionManager.INSTANCE.teleportToOverworld(target);
        RestrictedSpectatorManager.INSTANCE.disableRestrictedMode(target);
        target.method_7336(class_1934.field_9215);
        source.method_9226(() -> HardcoreCommands.forceReviveCommand$lambda$0(target), true);
        target.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7lYou have been revived by an admin!"));
        return 1;
    }

    private final int resetPlayerCommand(CommandContext<class_2168> context, class_3222 target) {
        class_2168 source = (class_2168)context.getSource();
        UUID uUID = target.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerStateManager.INSTANCE.resetPlayer(uUID);
        RestrictedSpectatorManager.INSTANCE.disableRestrictedMode(target);
        target.method_7336(class_1934.field_9215);
        source.method_9226(() -> HardcoreCommands.resetPlayerCommand$lambda$0(target), true);
        target.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aYour hardcore status has been reset!"));
        return 1;
    }

    private final int restoreHeartsCommand(CommandContext<class_2168> context, class_3222 target, int amount) {
        class_2168 source = (class_2168)context.getSource();
        int restored = DeathHandler.INSTANCE.restoreHearts(target, amount);
        if (restored > 0) {
            PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(target);
            int currentHearts = 10 - state.getLostHearts();
            source.method_9226(() -> HardcoreCommands.restoreHeartsCommand$lambda$0(restored, target), true);
            source.method_9226(() -> HardcoreCommands.restoreHeartsCommand$lambda$1(currentHearts), false);
            target.method_64398((class_2561)class_2561.method_43470((String)("\u00a7a\u00a7l+" + restored + " Heart(s) restored!")));
            target.method_64398((class_2561)class_2561.method_43470((String)("\u00a7eYou now have \u00a7c" + currentHearts + "\u00a7e/10 hearts.")));
        } else {
            source.method_9226(() -> HardcoreCommands.restoreHeartsCommand$lambda$2(target), false);
        }
        return 1;
    }

    private final int regenerateParkourCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        source.method_9226(HardcoreCommands::regenerateParkourCommand$lambda$0, true);
        boolean success = DimensionManager.INSTANCE.setupDimension(server);
        if (success) {
            source.method_9226(HardcoreCommands::regenerateParkourCommand$lambda$1, true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to regenerate parkour!"));
        return 0;
    }

    private final int startGameCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        if (GameSessionManager.INSTANCE.isGameActive()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cA game is already running!"));
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a77Use /hardcore stop to end it."));
            return 0;
        }
        if (!DimensionManager.INSTANCE.isDimensionSetup()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cPurgatory dimension not setup!"));
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a77Run /hardcore setup first."));
            return 0;
        }
        boolean success = GameSessionManager.INSTANCE.startGame(server);
        if (success) {
            source.method_9226(HardcoreCommands::startGameCommand$lambda$0, true);
            List list = server.method_3760().method_14571();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player = (class_3222)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)player);
                NetworkHandler.INSTANCE.sendStatusUpdate(player);
            }
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to start the game!"));
        return 0;
    }

    private final int stopGameCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        if (!GameSessionManager.INSTANCE.isGameActive()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cNo active game!"));
            return 0;
        }
        boolean success = GameSessionManager.INSTANCE.stopGame(server, "Stopped by admin");
        if (success) {
            source.method_9226(HardcoreCommands::stopGameCommand$lambda$0, true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to stop the game!"));
        return 0;
    }

    private final int pauseGameCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        if (!GameSessionManager.INSTANCE.isGameActive()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cNo active game!"));
            return 0;
        }
        if (GameSessionManager.INSTANCE.isGamePaused()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cGame is already paused!"));
            return 0;
        }
        boolean success = GameSessionManager.INSTANCE.pauseGame(server);
        if (success) {
            source.method_9226(HardcoreCommands::pauseGameCommand$lambda$0, true);
            return 1;
        }
        return 0;
    }

    private final int resumeGameCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        if (!GameSessionManager.INSTANCE.isGameActive()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cNo active game!"));
            return 0;
        }
        if (!GameSessionManager.INSTANCE.isGamePaused()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cGame is not paused!"));
            return 0;
        }
        boolean success = GameSessionManager.INSTANCE.resumeGame(server);
        if (success) {
            source.method_9226(HardcoreCommands::resumeGameCommand$lambda$0, true);
            return 1;
        }
        return 0;
    }

    private final int showTimeCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!GameSessionManager.INSTANCE.isGameActive()) {
            source.method_9226(HardcoreCommands::showTimeCommand$lambda$0, false);
            return 1;
        }
        SessionStats stats = GameSessionManager.INSTANCE.getStats();
        String pauseStatus = stats.isPaused() ? " \u00a7c[PAUSED]" : "";
        source.method_9226(HardcoreCommands::showTimeCommand$lambda$1, false);
        source.method_9226(() -> HardcoreCommands.showTimeCommand$lambda$2(stats, pauseStatus), false);
        source.method_9226(() -> HardcoreCommands.showTimeCommand$lambda$3(stats), false);
        source.method_9226(() -> HardcoreCommands.showTimeCommand$lambda$4(stats), false);
        return 1;
    }

    private final int gravesCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        Map<UUID, class_2338> graves = GraveManager.INSTANCE.getAllGraves();
        if (graves.isEmpty()) {
            source.method_9226(HardcoreCommands::gravesCommand$lambda$0, false);
            return 1;
        }
        source.method_9226(HardcoreCommands::gravesCommand$lambda$1, false);
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        for (Map.Entry<UUID, class_2338> entry : graves.entrySet()) {
            Object object;
            String statusColor;
            UUID uuid = entry.getKey();
            class_2338 pos = entry.getValue();
            PlayerStateData playerState = PlayerStateManager.INSTANCE.getPlayerState(uuid);
            Object object2 = playerState;
            if (object2 == null || (object2 = ((PlayerStateData)object2).getPlayerName()) == null) {
                object2 = "Unknown";
            }
            Object playerName = object2;
            PlayerStateData playerStateData = playerState;
            PlayerStatus playerStatus = playerStateData != null ? playerStateData.getStatus() : null;
            switch (playerStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[playerStatus.ordinal()]) {
                case 2: {
                    String string = "\u00a7e";
                    break;
                }
                case 3: {
                    String string = "\u00a7c";
                    break;
                }
                default: {
                    String string = statusColor = "\u00a7a";
                }
            }
            if ((object = playerState) == null || (object = ((PlayerStateData)object).getStatus()) == null || (object = ((Enum)object).name()) == null) {
                object = "UNKNOWN";
            }
            Object statusText = object;
            source.method_9226(() -> HardcoreCommands.gravesCommand$lambda$2((String)playerName, statusColor, (String)statusText), false);
            source.method_9226(() -> HardcoreCommands.gravesCommand$lambda$3(pos), false);
        }
        return 1;
    }

    private final int craftCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"));
            return 0;
        }
        source.method_9226(HardcoreCommands::craftCommand$lambda$0, false);
        source.method_9226(HardcoreCommands::craftCommand$lambda$1, false);
        boolean success = ReviveCraftingHandler.INSTANCE.tryCraftReviveTotem(player);
        return success ? 1 : 0;
    }

    private final int challengeSetupCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command must be run by a player standing in the challenge dimension!"));
            return 0;
        }
        if (!ChallengeManager.INSTANCE.isInChallengeDimension(player)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou must be in the challenge dimension to set it up!"));
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a77Teleport there first using /execute in hardcore-mod:challenge run tp @s ~ ~ ~"));
            return 0;
        }
        class_2338 class_23382 = player.method_24515();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"blockPosition(...)");
        class_2338 pos = class_23382;
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        ChallengeManager.INSTANCE.setSpawnPoint(pos);
        class_2338 class_23383 = pos.method_10069(0, 0, 50);
        Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"offset(...)");
        class_2338 completionPos = class_23383;
        ChallengeManager.INSTANCE.setCompletionPoint(completionPos);
        boolean success = ChallengeManager.INSTANCE.setupChallenge(server, pos, completionPos);
        if (success) {
            source.method_9226(HardcoreCommands::challengeSetupCommand$lambda$0, true);
            source.method_9226(() -> HardcoreCommands.challengeSetupCommand$lambda$1(pos), false);
            source.method_9226(() -> HardcoreCommands.challengeSetupCommand$lambda$2(completionPos), false);
            source.method_9226(HardcoreCommands::challengeSetupCommand$lambda$3, false);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to setup challenge dimension!"));
        return 0;
    }

    private final int challengeAcceptCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"));
            return 0;
        }
        boolean success = ChallengeManager.INSTANCE.acceptChallenge(player);
        return success ? 1 : 0;
    }

    private final int challengeDeclineCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"));
            return 0;
        }
        boolean success = ChallengeManager.INSTANCE.declineChallenge(player);
        return success ? 1 : 0;
    }

    private final int discordEnableCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        DiscordNotifier.INSTANCE.enable();
        source.method_9226(HardcoreCommands::discordEnableCommand$lambda$0, true);
        return 1;
    }

    private final int discordDisableCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        DiscordNotifier.INSTANCE.disable();
        source.method_9226(HardcoreCommands::discordDisableCommand$lambda$0, true);
        return 1;
    }

    private final int discordStatusCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(HardcoreCommands::discordStatusCommand$lambda$0, false);
        String statusColor = DiscordNotifier.INSTANCE.getEnabled() ? "\u00a7a" : "\u00a7c";
        String statusText = DiscordNotifier.INSTANCE.getEnabled() ? "Aktiviert" : "Deaktiviert";
        source.method_9226(() -> HardcoreCommands.discordStatusCommand$lambda$1(statusColor, statusText), false);
        source.method_9226(HardcoreCommands::discordStatusCommand$lambda$2, false);
        return 1;
    }

    private final int discordTestCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        if (!DiscordNotifier.INSTANCE.getEnabled()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cDiscord-Benachrichtigungen sind deaktiviert!"));
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a77Verwende /hardcore discord enable"));
            return 0;
        }
        DeathHandler.PlayerStats stats = DeathHandler.INSTANCE.getPlayerStats(server);
        DiscordNotifier.INSTANCE.onStatusUpdate(stats.getAlive(), stats.getDead(), stats.getSpectators(), GameSessionManager.INSTANCE.getFormattedTime());
        source.method_9226(HardcoreCommands::discordTestCommand$lambda$0, true);
        return 1;
    }

    private final int discordSetUrlCommand(CommandContext<class_2168> context, String url) {
        class_2168 source = (class_2168)context.getSource();
        if (!StringsKt.startsWith$default((String)url, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cUng\u00fcltige URL! Muss mit http:// oder https:// beginnen."));
            return 0;
        }
        DiscordNotifier.INSTANCE.setEndpoint(url);
        source.method_9226(() -> HardcoreCommands.discordSetUrlCommand$lambda$0(url), true);
        return 1;
    }

    private static final void register$lambda$0(CommandDispatcher dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        INSTANCE.registerCommands((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final boolean registerCommands$lambda$0(class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.method_75037().hasPermission(class_12099.field_63210);
    }

    private static final int registerCommands$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.setupCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$2(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.resetCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$3(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.statusCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$4(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"player");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        return INSTANCE.forceReviveCommand((CommandContext<class_2168>)context, class_32222);
    }

    private static final int registerCommands$lambda$5(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"player");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        return INSTANCE.resetPlayerCommand((CommandContext<class_2168>)context, class_32222);
    }

    private static final int registerCommands$lambda$6(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.regenerateParkourCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$7(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"player");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        return INSTANCE.restoreHeartsCommand((CommandContext<class_2168>)context, class_32222, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"));
    }

    private static final int registerCommands$lambda$8(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"player");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        return INSTANCE.restoreHeartsCommand((CommandContext<class_2168>)context, class_32222, 10);
    }

    private static final int registerCommands$lambda$9(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.challengeSetupCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$10(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.startGameCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$11(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.stopGameCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$12(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.pauseGameCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$13(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.resumeGameCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$14(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.showTimeCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$15(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.discordEnableCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$16(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.discordDisableCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$17(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.discordStatusCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$18(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.discordTestCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$19(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String string = StringArgumentType.getString((CommandContext)context, (String)"url");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.discordSetUrlCommand((CommandContext<class_2168>)context, string);
    }

    private static final boolean registerCommands$lambda$20(class_2168 it) {
        return true;
    }

    private static final int registerCommands$lambda$21(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.craftCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$22(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.craftCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$23(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.reviveHelpCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$24(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.gravesCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$25(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.reviveHelpCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$26(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.challengeAcceptCommand((CommandContext<class_2168>)context);
    }

    private static final int registerCommands$lambda$27(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.challengeDeclineCommand((CommandContext<class_2168>)context);
    }

    private static final class_2561 reviveHelpCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a76=== Revive Totem Crafting ===");
    }

    private static final class_2561 reviveHelpCommand$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"\u00a77To craft a Revive Totem, you need:");
    }

    private static final class_2561 reviveHelpCommand$lambda$2() {
        return (class_2561)class_2561.method_43470((String)"\u00a7e  - Player Head \u00a77(of dead player in purgatory)");
    }

    private static final class_2561 reviveHelpCommand$lambda$3() {
        return (class_2561)class_2561.method_43470((String)"\u00a7e  - Mace");
    }

    private static final class_2561 reviveHelpCommand$lambda$4() {
        return (class_2561)class_2561.method_43470((String)"\u00a7e  - Beacon");
    }

    private static final class_2561 reviveHelpCommand$lambda$5() {
        return (class_2561)class_2561.method_43470((String)"\u00a7e  - Nether Star");
    }

    private static final class_2561 reviveHelpCommand$lambda$6() {
        return (class_2561)class_2561.method_43470((String)"\u00a7e  - Totem of Undying");
    }

    private static final class_2561 reviveHelpCommand$lambda$7() {
        return (class_2561)class_2561.method_43470((String)"");
    }

    private static final class_2561 reviveHelpCommand$lambda$8() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aUse \u00a7f/revive craft\u00a7a with items in your inventory!");
    }

    private static final class_2561 setupCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7eSetting up Hardcore Mod purgatory dimension...");
    }

    private static final class_2561 setupCommand$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aPurgatory dimension setup complete!");
    }

    private static final class_2561 setupCommand$lambda$2() {
        return (class_2561)class_2561.method_43470((String)"\u00a77Parkour has been generated.");
    }

    private static final class_2561 resetCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aHardcore mod reset complete!");
    }

    private static final class_2561 resetCommand$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"\u00a77All player states have been reset.");
    }

    private static final class_2561 resetCommand$lambda$2() {
        return (class_2561)class_2561.method_43470((String)"\u00a77Run /hardcore setup to regenerate parkour.");
    }

    private static final class_2561 statusCommand$lambda$4$0(class_3222 $player, String $statusText, String $deathCount) {
        return (class_2561)class_2561.method_43470((String)("  \u00a7f" + $player.method_7334().name() + ": " + $statusText + " " + $deathCount));
    }

    private static final class_2561 statusCommand$lambda$4$1(String $parkourStatus, String $craftingStatus) {
        return (class_2561)class_2561.method_43470((String)("    \u00a77Parkour: " + $parkourStatus + " | Crafting: " + $craftingStatus));
    }

    private static final class_2561 statusCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a76=== Hardcore Mod Status ===");
    }

    private static final class_2561 statusCommand$lambda$1(String $dimensionStatus) {
        return (class_2561)class_2561.method_43470((String)("\u00a77Purgatory Dimension: " + $dimensionStatus));
    }

    private static final class_2561 statusCommand$lambda$2() {
        return (class_2561)class_2561.method_43470((String)"\u00a77");
    }

    private static final class_2561 statusCommand$lambda$3() {
        return (class_2561)class_2561.method_43470((String)"\u00a76Player Status:");
    }

    private static final class_2561 forceReviveCommand$lambda$0(class_3222 $target) {
        return (class_2561)class_2561.method_43470((String)("\u00a7a" + $target.method_7334().name() + " has been revived!"));
    }

    private static final class_2561 resetPlayerCommand$lambda$0(class_3222 $target) {
        return (class_2561)class_2561.method_43470((String)("\u00a7a" + $target.method_7334().name() + "'s hardcore status has been reset!"));
    }

    private static final class_2561 restoreHeartsCommand$lambda$0(int $restored, class_3222 $target) {
        return (class_2561)class_2561.method_43470((String)("\u00a7aRestored " + $restored + " heart(s) to " + $target.method_7334().name() + "!"));
    }

    private static final class_2561 restoreHeartsCommand$lambda$1(int $currentHearts) {
        return (class_2561)class_2561.method_43470((String)("\u00a77They now have " + $currentHearts + "/10 hearts."));
    }

    private static final class_2561 restoreHeartsCommand$lambda$2(class_3222 $target) {
        return (class_2561)class_2561.method_43470((String)("\u00a7e" + $target.method_7334().name() + " already has full hearts!"));
    }

    private static final class_2561 regenerateParkourCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7eRegenerating parkour...");
    }

    private static final class_2561 regenerateParkourCommand$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aParkour regenerated with new variant!");
    }

    private static final class_2561 startGameCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aHardcore mode started!");
    }

    private static final class_2561 stopGameCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aHardcore mode stopped!");
    }

    private static final class_2561 pauseGameCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)("\u00a7eGame paused at " + GameSessionManager.INSTANCE.getFormattedTime()));
    }

    private static final class_2561 resumeGameCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aGame resumed!");
    }

    private static final class_2561 showTimeCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a77No active game.");
    }

    private static final class_2561 showTimeCommand$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"\u00a76=== Game Time ===");
    }

    private static final class_2561 showTimeCommand$lambda$2(SessionStats $stats, String $pauseStatus) {
        return (class_2561)class_2561.method_43470((String)("\u00a7eTime: \u00a7f" + $stats.getElapsedTime() + $pauseStatus));
    }

    private static final class_2561 showTimeCommand$lambda$3(SessionStats $stats) {
        return (class_2561)class_2561.method_43470((String)("\u00a7aAlive: \u00a7f" + $stats.getAlivePlayers()));
    }

    private static final class_2561 showTimeCommand$lambda$4(SessionStats $stats) {
        return (class_2561)class_2561.method_43470((String)("\u00a7eIn Purgatory: \u00a7f" + $stats.getPurgatoryPlayers()));
    }

    private static final class_2561 gravesCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a77No graves currently exist.");
    }

    private static final class_2561 gravesCommand$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"\u00a76=== Player Graves ===");
    }

    private static final class_2561 gravesCommand$lambda$2(String $playerName, String $statusColor, String $statusText) {
        return (class_2561)class_2561.method_43470((String)("\u00a76\u2620 \u00a7f" + $playerName + " " + $statusColor + "[" + $statusText + "]"));
    }

    private static final class_2561 gravesCommand$lambda$3(class_2338 $pos) {
        return (class_2561)class_2561.method_43470((String)("   \u00a77Location: \u00a7eX=" + $pos.method_10263() + ", Y=" + $pos.method_10264() + ", Z=" + $pos.method_10260()));
    }

    private static final class_2561 craftCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7eAttempting to craft Revive Totem...");
    }

    private static final class_2561 craftCommand$lambda$1() {
        return (class_2561)class_2561.method_43470((String)"\u00a77Required: Player Head + Mace + Beacon + Nether Star + Totem of Undying");
    }

    private static final class_2561 challengeSetupCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aChallenge dimension setup complete!");
    }

    private static final class_2561 challengeSetupCommand$lambda$1(class_2338 $pos) {
        return (class_2561)class_2561.method_43470((String)("\u00a77Spawn point: X=" + $pos.method_10263() + ", Y=" + $pos.method_10264() + ", Z=" + $pos.method_10260()));
    }

    private static final class_2561 challengeSetupCommand$lambda$2(class_2338 $completionPos) {
        return (class_2561)class_2561.method_43470((String)("\u00a77Default completion point: X=" + $completionPos.method_10263() + ", Y=" + $completionPos.method_10264() + ", Z=" + $completionPos.method_10260()));
    }

    private static final class_2561 challengeSetupCommand$lambda$3() {
        return (class_2561)class_2561.method_43470((String)"\u00a77Place an emerald block with a pressure plate on top at your finish location!");
    }

    private static final class_2561 discordEnableCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aDiscord-Benachrichtigungen aktiviert!");
    }

    private static final class_2561 discordDisableCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7eDiscord-Benachrichtigungen deaktiviert!");
    }

    private static final class_2561 discordStatusCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a76=== Discord Integration ===");
    }

    private static final class_2561 discordStatusCommand$lambda$1(String $statusColor, String $statusText) {
        return (class_2561)class_2561.method_43470((String)("\u00a77Status: " + $statusColor + $statusText));
    }

    private static final class_2561 discordStatusCommand$lambda$2() {
        return (class_2561)class_2561.method_43470((String)("\u00a77Endpoint: \u00a7f" + DiscordNotifier.INSTANCE.getEndpointUrl()));
    }

    private static final class_2561 discordTestCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"\u00a7aTest-Nachricht an Discord gesendet!");
    }

    private static final class_2561 discordSetUrlCommand$lambda$0(String $url) {
        return (class_2561)class_2561.method_43470((String)("\u00a7aDiscord Endpoint gesetzt: \u00a7f" + $url));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerStatus.values().length];
            try {
                nArray[PlayerStatus.ALIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerStatus.IN_PURGATORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerStatus.SPECTATOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

