/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.PlayerStatus;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J7\u0010#\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010(\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010,\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010/\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u0004\u00a2\u0006\u0004\b/\u00100J\u001d\u00103\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u00102\u001a\u000201\u00a2\u0006\u0004\b3\u00104J\u0015\u00105\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\u0004\b5\u00106J\u0017\u00107\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b7\u00108J\r\u00109\u001a\u00020\b\u00a2\u0006\u0004\b9\u0010\u0003J\u0019\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060:\u00a2\u0006\u0004\b;\u0010<J!\u0010>\u001a\u00020\b2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060:\u00a2\u0006\u0004\b>\u0010?R\u001c\u0010B\u001a\n A*\u0004\u0018\u00010@0@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR \u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060D8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010FR&\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0G0D8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010F\u00a8\u0006I"}, d2={"Lrevive/mod/GraveManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_2338;", "deathPos", "", "createGrave", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;)V", "Ljava/util/UUID;", "deadPlayerUUID", "Lnet/minecraft/class_1799;", "item", "storeItemInGrave", "(Ljava/util/UUID;Lnet/minecraft/class_1799;)V", "playerUUID", "", "getGraveItems", "(Ljava/util/UUID;)Ljava/util/List;", "clearGraveItems", "(Ljava/util/UUID;)V", "", "hasStoredItems", "(Ljava/util/UUID;)Z", "pos", "onGraveInteract", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;)Z", "Lnet/minecraft/class_3218;", "level", "handleOwnerGraveInteract", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;Lnet/minecraft/class_3218;)Z", "Lrevive/mod/PlayerStateData;", "deadPlayerState", "handleAlivePlayerGraveInteract", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;Ljava/util/UUID;Lrevive/mod/PlayerStateData;Lnet/minecraft/class_3218;)Z", "getGraveOwnerByPos", "(Lnet/minecraft/class_2338;)Ljava/util/UUID;", "startPos", "findGravePosition", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Lnet/minecraft/class_2338;", "getGraveOwner", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Ljava/util/UUID;", "removeGrave", "(Ljava/util/UUID;Lnet/minecraft/class_3218;)V", "deadPlayer", "createPlayerHeadItem", "(Lnet/minecraft/class_3222;)Lnet/minecraft/class_1799;", "", "playerName", "createPlayerHeadItemFromUUID", "(Ljava/util/UUID;Ljava/lang/String;)Lnet/minecraft/class_1799;", "isGravePosition", "(Lnet/minecraft/class_2338;)Z", "getGraveLocation", "(Ljava/util/UUID;)Lnet/minecraft/class_2338;", "reset", "", "getAllGraves", "()Ljava/util/Map;", "graves", "loadFromSavedData", "(Ljava/util/Map;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Ljava/util/concurrent/ConcurrentHashMap;", "graveLocations", "Ljava/util/concurrent/ConcurrentHashMap;", "", "graveItems", "hardcore-mod"})
public final class GraveManager {
    @NotNull
    public static final GraveManager INSTANCE = new GraveManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    private static final ConcurrentHashMap<UUID, class_2338> graveLocations = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, List<class_1799>> graveItems = new ConcurrentHashMap();

    private GraveManager() {
    }

    public final void createGrave(@NotNull class_3222 player, @NotNull class_2338 deathPos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)deathPos, (String)"deathPos");
        class_3218 class_32182 = player.method_51469();
        Intrinsics.checkNotNull((Object)class_32182, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        class_3218 level = class_32182;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        UUID playerUUID = uUID;
        String playerName = player.method_7334().name();
        class_2338 gravePos = this.findGravePosition(level, deathPos);
        logger.info("Creating grave for " + playerName + " at " + gravePos);
        level.method_8652(gravePos, class_2246.field_10114.method_9564(), 3);
        class_2338 class_23382 = gravePos.method_10084();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"above(...)");
        class_2338 headPos = class_23382;
        level.method_8652(headPos, class_2246.field_10432.method_9564(), 3);
        class_2680 class_26802 = class_2246.field_22110.method_9564();
        Intrinsics.checkNotNullExpressionValue((Object)class_26802, (String)"defaultBlockState(...)");
        class_2680 candleState = class_26802;
        level.method_8652(gravePos.method_10095(), candleState, 3);
        level.method_8652(gravePos.method_10072(), candleState, 3);
        ((Map)graveLocations).put(playerUUID, headPos);
        MinecraftServer minecraftServer = level.method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        for (Object e : server.method_3760().method_14571()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            class_3222 p = (class_3222)e;
            PlayerStateData playerState = PlayerStateManager.INSTANCE.getPlayerState(p);
            if (playerState.getStatus() != PlayerStatus.ALIVE) continue;
            p.method_64398((class_2561)class_2561.method_43470((String)("\u00a76\u00a7l\u2620 \u00a7e" + playerName + "\u00a76's grave has been created!")));
            p.method_64398((class_2561)class_2561.method_43470((String)("\u00a77Location: X=" + gravePos.method_10263() + ", Y=" + gravePos.method_10264() + ", Z=" + gravePos.method_10260())));
            p.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Click on the grave to collect their head!"));
        }
        logger.info("Grave created for " + playerName + " at " + gravePos);
    }

    public final void storeItemInGrave(@NotNull UUID deadPlayerUUID, @NotNull class_1799 item) {
        Intrinsics.checkNotNullParameter((Object)deadPlayerUUID, (String)"deadPlayerUUID");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!item.method_7960()) {
            class_1799 class_17992 = item.method_7972();
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"copy(...)");
            graveItems.computeIfAbsent(deadPlayerUUID, arg_0 -> GraveManager.storeItemInGrave$lambda$1(GraveManager::storeItemInGrave$lambda$0, arg_0)).add(class_17992);
        }
    }

    @NotNull
    public final List<class_1799> getGraveItems(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        List list = graveItems.get(playerUUID);
        if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void clearGraveItems(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        graveItems.remove(playerUUID);
    }

    public final boolean hasStoredItems(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        List<class_1799> list = graveItems.get(playerUUID);
        return list != null ? !((Collection)list).isEmpty() : false;
    }

    public final boolean onGraveInteract(@NotNull class_3222 player, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        class_3218 class_32182 = player.method_51469();
        Object object = class_32182 instanceof class_3218 ? class_32182 : null;
        if (object == null) {
            return false;
        }
        class_3218 level = object;
        UUID uUID = this.getGraveOwnerByPos(pos);
        if (uUID == null) {
            return false;
        }
        UUID deadPlayerUUID = uUID;
        PlayerStateData deadPlayerState = PlayerStateManager.INSTANCE.getPlayerState(deadPlayerUUID);
        if (deadPlayerState == null) {
            logger.warn("Could not find state for grave owner " + deadPlayerUUID);
            return false;
        }
        PlayerStateData clickerState = PlayerStateManager.INSTANCE.getPlayerState(player);
        if (Intrinsics.areEqual((Object)player.method_5667(), (Object)deadPlayerUUID) && clickerState.getStatus() == PlayerStatus.ALIVE) {
            return this.handleOwnerGraveInteract(player, pos, level);
        }
        if (clickerState.getStatus() == PlayerStatus.ALIVE) {
            return this.handleAlivePlayerGraveInteract(player, pos, deadPlayerUUID, deadPlayerState, level);
        }
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cOnly alive players can interact with graves!"));
        return false;
    }

    private final boolean handleOwnerGraveInteract(class_3222 player, class_2338 pos, class_3218 level) {
        List<class_1799> items = graveItems.get(player.method_5667());
        if (items == null || items.isEmpty()) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Your grave is empty."));
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            this.removeGrave(uUID, level);
            return true;
        }
        int itemsGiven = 0;
        int itemsDropped = 0;
        for (class_1799 item : items) {
            if (!player.method_31548().method_7394(item.method_7972())) {
                player.method_7328(item.method_7972(), false);
                ++itemsDropped;
                continue;
            }
            ++itemsGiven;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.clearGraveItems(uUID);
        level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, 1.0f, 1.0f);
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        this.removeGrave(uUID2, level);
        if (itemsDropped > 0) {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7aYou retrieved your items! \u00a77(" + itemsDropped + " items dropped - inventory full)")));
        } else {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aYou retrieved all your items from your grave!"));
        }
        logger.info(player.method_7334().name() + " retrieved " + (itemsGiven + itemsDropped) + " items from their grave");
        return true;
    }

    private final boolean handleAlivePlayerGraveInteract(class_3222 player, class_2338 pos, UUID deadPlayerUUID, PlayerStateData deadPlayerState, class_3218 level) {
        if (deadPlayerState.getStatus() != PlayerStatus.IN_PURGATORY) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77This player has already been revived. They can collect their items themselves."));
            return false;
        }
        class_1799 playerHead = this.createPlayerHeadItemFromUUID(deadPlayerUUID, deadPlayerState.getPlayerName());
        if (!player.method_31548().method_7394(playerHead)) {
            player.method_7328(playerHead, false);
        }
        level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, 1.0f, 1.0f);
        player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7aYou collected \u00a7e" + deadPlayerState.getPlayerName() + "\u00a7a's head!")));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7f/revive craft\u00a77 with the required items to revive them."));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77The grave will remain for them to collect their items after revival."));
        logger.info(player.method_7334().name() + " collected head from " + deadPlayerState.getPlayerName() + "'s grave");
        return true;
    }

    private final UUID getGraveOwnerByPos(class_2338 pos) {
        for (Map.Entry entry : ((Map)graveLocations).entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            class_2338 gravePos = (class_2338)entry.getValue();
            if (!Intrinsics.areEqual((Object)gravePos, (Object)pos)) continue;
            return uuid;
        }
        return null;
    }

    private final class_2338 findGravePosition(class_3218 level, class_2338 startPos) {
        class_2338 pos = startPos;
        while (level.method_8320(pos.method_10074()).method_26215() && pos.method_10264() > level.method_31607() + 1) {
            Intrinsics.checkNotNullExpressionValue((Object)pos.method_10074(), (String)"below(...)");
        }
        while (!level.method_8320(pos).method_26215() && pos.method_10264() < level.method_31600() - 2) {
            Intrinsics.checkNotNullExpressionValue((Object)pos.method_10084(), (String)"above(...)");
        }
        return pos;
    }

    @Nullable
    public final UUID getGraveOwner(@NotNull class_3218 level, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        for (Map.Entry entry : ((Map)graveLocations).entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            class_2338 gravePos = (class_2338)entry.getValue();
            if (!Intrinsics.areEqual((Object)gravePos, (Object)pos)) continue;
            return uuid;
        }
        return null;
    }

    public final void removeGrave(@NotNull UUID playerUUID, @NotNull class_3218 level) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        class_2338 class_23382 = graveLocations.remove(playerUUID);
        if (class_23382 == null) {
            return;
        }
        class_2338 gravePos = class_23382;
        level.method_8652(gravePos, class_2246.field_10124.method_9564(), 3);
        level.method_8652(gravePos.method_10074(), class_2246.field_10124.method_9564(), 3);
        level.method_8652(gravePos.method_10074().method_10095(), class_2246.field_10124.method_9564(), 3);
        level.method_8652(gravePos.method_10074().method_10072(), class_2246.field_10124.method_9564(), 3);
        logger.info("Grave removed for player " + playerUUID);
    }

    @NotNull
    public final class_1799 createPlayerHeadItem(@NotNull class_3222 deadPlayer) {
        Intrinsics.checkNotNullParameter((Object)deadPlayer, (String)"deadPlayer");
        class_1799 playerHead = new class_1799((class_1935)class_1802.field_8575);
        try {
            class_9296 class_92962 = class_9296.method_73307((GameProfile)deadPlayer.method_7334());
            Intrinsics.checkNotNullExpressionValue((Object)class_92962, (String)"createResolved(...)");
            class_9296 profileComponent = class_92962;
            playerHead.method_57379(class_9334.field_49617, (Object)profileComponent);
        }
        catch (Exception e) {
            logger.error("Error setting player head owner: " + e.getMessage());
        }
        return playerHead;
    }

    @NotNull
    public final class_1799 createPlayerHeadItemFromUUID(@NotNull UUID playerUUID, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        class_1799 playerHead = new class_1799((class_1935)class_1802.field_8575);
        try {
            GameProfile gameProfile = new GameProfile(playerUUID, playerName);
            class_9296 class_92962 = class_9296.method_73307((GameProfile)gameProfile);
            Intrinsics.checkNotNullExpressionValue((Object)class_92962, (String)"createResolved(...)");
            class_9296 profileComponent = class_92962;
            playerHead.method_57379(class_9334.field_49617, (Object)profileComponent);
        }
        catch (Exception e) {
            logger.error("Error setting player head owner from UUID: " + e.getMessage());
        }
        return playerHead;
    }

    public final boolean isGravePosition(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return graveLocations.values().contains(pos);
    }

    @Nullable
    public final class_2338 getGraveLocation(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        return graveLocations.get(playerUUID);
    }

    public final void reset() {
        graveLocations.clear();
    }

    @NotNull
    public final Map<UUID, class_2338> getAllGraves() {
        return MapsKt.toMap((Map)graveLocations);
    }

    public final void loadFromSavedData(@NotNull Map<UUID, ? extends class_2338> graves) {
        Intrinsics.checkNotNullParameter(graves, (String)"graves");
        graveLocations.clear();
        graveLocations.putAll(graves);
    }

    private static final List storeItemInGrave$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List storeItemInGrave$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

