/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.DeathHandler;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.PlayerStatus;
import revive.mod.ReviveTask;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\fJ\u001d\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lrevive/mod/ReviveRecipeManager;", "", "<init>", "()V", "", "Lnet/minecraft/class_1799;", "items", "Ljava/util/UUID;", "checkReviveRecipe", "(Ljava/util/List;)Ljava/util/UUID;", "headStack", "getPlayerHeadOwner", "(Lnet/minecraft/class_1799;)Ljava/util/UUID;", "deadPlayerUUID", "", "deadPlayerName", "createReviveTotem", "(Ljava/util/UUID;Ljava/lang/String;)Lnet/minecraft/class_1799;", "item", "getReviveTotemTarget", "totem", "Lnet/minecraft/class_3222;", "user", "", "onReviveTotemUsed", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_3222;)V", "deadPlayer", "distributePlayerHead", "(Lnet/minecraft/class_3222;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "REVIVE_TOTEM_TAG", "Ljava/lang/String;", "hardcore-mod"})
public final class ReviveRecipeManager {
    @NotNull
    public static final ReviveRecipeManager INSTANCE = new ReviveRecipeManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    public static final String REVIVE_TOTEM_TAG = "hardcore_revive_totem";

    private ReviveRecipeManager() {
    }

    @Nullable
    public final UUID checkReviveRecipe(@NotNull List<class_1799> items) {
        UUID uUID;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        UUID playerHeadUUID = null;
        boolean hasMace = false;
        boolean hasBeacon = false;
        boolean hasNetherStar = false;
        boolean hasTotemOfUndying = false;
        logger.info("Checking revive recipe with " + items.size() + " items");
        Iterator iterator = ((Iterable)items).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String itemName;
            int index = n++;
            class_1799 item = (class_1799)iterator.next();
            if (item.method_7960()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)item.method_7909().toString(), (String)"toString(...)");
            logger.info("  Slot " + index + ": " + itemName);
            if (item.method_31574(class_1802.field_8575)) {
                logger.info("  Found player head!");
                playerHeadUUID = this.getPlayerHeadOwner(item);
                logger.info("  Player head UUID: " + playerHeadUUID);
                continue;
            }
            if (item.method_31574(class_1802.field_49814)) {
                hasMace = true;
                logger.info("  Found mace!");
                continue;
            }
            if (item.method_31574(class_1802.field_8668)) {
                hasBeacon = true;
                logger.info("  Found beacon!");
                continue;
            }
            if (item.method_31574(class_1802.field_8137)) {
                hasNetherStar = true;
                logger.info("  Found nether star!");
                continue;
            }
            if (!item.method_31574(class_1802.field_8288)) continue;
            hasTotemOfUndying = true;
            logger.info("  Found totem!");
        }
        logger.info("Recipe check: head=" + playerHeadUUID + ", mace=" + hasMace + ", beacon=" + hasBeacon + ", star=" + hasNetherStar + ", totem=" + hasTotemOfUndying);
        if (playerHeadUUID != null) {
            PlayerStateData state;
            PlayerStateData playerStateData = state = PlayerStateManager.INSTANCE.getPlayerState(playerHeadUUID);
            logger.info("Player state for " + playerHeadUUID + ": " + (playerStateData != null ? playerStateData.getStatus() : null));
            if (state == null || state.getStatus() != PlayerStatus.IN_PURGATORY) {
                logger.info("Player is not in purgatory, invalidating recipe");
                playerHeadUUID = null;
            }
        }
        if (playerHeadUUID != null && hasMace && hasBeacon && hasNetherStar && hasTotemOfUndying) {
            logger.info("Valid revive recipe detected for player " + playerHeadUUID);
            uUID = playerHeadUUID;
        } else {
            logger.info("Recipe not valid");
            uUID = null;
        }
        return uUID;
    }

    private final UUID getPlayerHeadOwner(class_1799 headStack) {
        try {
            class_9296 profile = (class_9296)headStack.method_58694(class_9334.field_49617);
            if (profile != null) {
                logger.info("Found profile component on player head");
                GameProfile gameProfile = profile.method_73313();
                Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"partialProfile(...)");
                GameProfile partialProfile = gameProfile;
                UUID uuid = partialProfile.id();
                if (uuid != null) {
                    logger.info("Found UUID in partialProfile: " + uuid);
                    return uuid;
                }
                Optional optional = profile.method_73317();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"name(...)");
                Optional name = optional;
                if (name.isPresent()) {
                    logger.info("Profile has name: " + name.get() + " but no UUID directly available");
                }
            } else {
                logger.info("No profile component found on player head");
            }
        }
        catch (Exception e) {
            logger.error("Error getting player head owner: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @NotNull
    public final class_1799 createReviveTotem(@NotNull UUID deadPlayerUUID, @NotNull String deadPlayerName) {
        Intrinsics.checkNotNullParameter((Object)deadPlayerUUID, (String)"deadPlayerUUID");
        Intrinsics.checkNotNullParameter((Object)deadPlayerName, (String)"deadPlayerName");
        class_1799 totem = new class_1799((class_1935)class_1802.field_8288);
        totem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("\u00a76\u00a7lRevive Totem: \u00a7e" + deadPlayerName)));
        class_2487 tag = new class_2487();
        tag.method_10582(REVIVE_TOTEM_TAG, deadPlayerUUID.toString());
        totem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        return totem;
    }

    @Nullable
    public final UUID getReviveTotemTarget(@NotNull class_1799 item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!item.method_31574(class_1802.field_8288)) {
            return null;
        }
        try {
            class_9279 customData = (class_9279)item.method_58694(class_9334.field_49628);
            if (customData != null) {
                class_2487 class_24872 = customData.method_57461();
                Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"copyTag(...)");
                class_2487 tag = class_24872;
                if (tag.method_10545(REVIVE_TOTEM_TAG)) {
                    Optional optional = tag.method_10558(REVIVE_TOTEM_TAG);
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getString(...)");
                    Optional uuidStr = optional;
                    if (uuidStr.isPresent()) {
                        return UUID.fromString((String)uuidStr.get());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error reading revive totem data: " + e.getMessage());
        }
        return null;
    }

    public final void onReviveTotemUsed(@NotNull class_1799 totem, @NotNull class_3222 user) {
        Intrinsics.checkNotNullParameter((Object)totem, (String)"totem");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UUID uUID = this.getReviveTotemTarget(totem);
        if (uUID == null) {
            return;
        }
        UUID targetUUID = uUID;
        logger.info("Revive totem used by " + user.method_7334().name() + " for player " + targetUUID);
        MinecraftServer minecraftServer = user.method_51469().method_8503();
        Intrinsics.checkNotNull((Object)minecraftServer);
        DeathHandler.INSTANCE.onReviveItemCrafted(targetUUID, minecraftServer);
        totem.method_7934(1);
        user.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aRevive Totem activated!"));
        ReviveTask task = PlayerStateManager.INSTANCE.getReviveTask(targetUUID);
        if (task != null) {
            if (task.isComplete()) {
                user.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aPlayer is being revived!"));
            } else {
                user.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eWaiting for the dead player to complete the parkour..."));
            }
        }
    }

    public final void distributePlayerHead(@NotNull class_3222 deadPlayer) {
        Intrinsics.checkNotNullParameter((Object)deadPlayer, (String)"deadPlayer");
        MinecraftServer minecraftServer = deadPlayer.method_51469().method_8503();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        String deadPlayerName = deadPlayer.method_7334().name();
        UUID uUID = deadPlayer.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        UUID deadPlayerUUID = uUID;
        class_1799 playerHead = new class_1799((class_1935)class_1802.field_8575);
        try {
            GameProfile gameProfile = deadPlayer.method_7334();
            Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"getGameProfile(...)");
            GameProfile gameProfile2 = gameProfile;
            class_9296 class_92962 = class_9296.method_73307((GameProfile)gameProfile2);
            Intrinsics.checkNotNullExpressionValue((Object)class_92962, (String)"createResolved(...)");
            class_9296 profileComponent = class_92962;
            playerHead.method_57379(class_9334.field_49617, (Object)profileComponent);
        }
        catch (Exception e) {
            logger.error("Error setting player head owner: " + e.getMessage());
        }
        for (Object e : server.method_3760().method_14571()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            class_3222 alivePlayer = (class_3222)e;
            PlayerStateData playerState = PlayerStateManager.INSTANCE.getPlayerState(alivePlayer);
            if (playerState.getStatus() != PlayerStatus.ALIVE) continue;
            if (!alivePlayer.method_31548().method_7394(playerHead.method_7972())) {
                alivePlayer.method_7328(playerHead.method_7972(), false);
            }
            alivePlayer.method_64398((class_2561)class_2561.method_43470((String)("\u00a76You received the head of \u00a7e" + deadPlayerName + "\u00a76!")));
            alivePlayer.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Craft the revive item: Head + Mace + Beacon + Nether Star + Totem"));
        }
    }
}

