/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.GameSessionManager;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.PlayerStatus;
import revive.mod.ReviveRecipeManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lrevive/mod/ReviveCraftingHandler;", "", "<init>", "()V", "", "register", "Lnet/minecraft/class_3222;", "player", "", "tryCraftReviveTotem", "(Lnet/minecraft/class_3222;)Z", "Lnet/minecraft/class_1799;", "stack", "Ljava/util/UUID;", "getPlayerHeadUUID", "(Lnet/minecraft/class_1799;)Ljava/util/UUID;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "hardcore-mod"})
public final class ReviveCraftingHandler {
    @NotNull
    public static final ReviveCraftingHandler INSTANCE = new ReviveCraftingHandler();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");

    private ReviveCraftingHandler() {
    }

    public final void register() {
        UseItemCallback.EVENT.register(ReviveCraftingHandler::register$lambda$0);
        logger.info("Revive crafting handler registered");
    }

    public final boolean tryCraftReviveTotem(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!GameSessionManager.INSTANCE.isGameActive()) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cGame is not active!"));
            return false;
        }
        class_1661 class_16612 = player.method_31548();
        Intrinsics.checkNotNullExpressionValue((Object)class_16612, (String)"getInventory(...)");
        class_1661 inventory = class_16612;
        int playerHeadSlot = -1;
        UUID playerHeadUUID = null;
        int maceSlot = -1;
        int beaconSlot = -1;
        int netherStarSlot = -1;
        int totemSlot = -1;
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 stack;
            Intrinsics.checkNotNullExpressionValue((Object)inventory.method_5438(i), (String)"getItem(...)");
            if (stack.method_7960()) continue;
            if (stack.method_31574(class_1802.field_8575) && playerHeadSlot == -1) {
                PlayerStateData state;
                UUID uuid = this.getPlayerHeadUUID(stack);
                if (uuid == null || (state = PlayerStateManager.INSTANCE.getPlayerState(uuid)) == null || state.getStatus() != PlayerStatus.IN_PURGATORY) continue;
                playerHeadSlot = i;
                playerHeadUUID = uuid;
                continue;
            }
            if (stack.method_31574(class_1802.field_49814) && maceSlot == -1) {
                maceSlot = i;
                continue;
            }
            if (stack.method_31574(class_1802.field_8668) && beaconSlot == -1) {
                beaconSlot = i;
                continue;
            }
            if (stack.method_31574(class_1802.field_8137) && netherStarSlot == -1) {
                netherStarSlot = i;
                continue;
            }
            if (!stack.method_31574(class_1802.field_8288) || totemSlot != -1 || ReviveRecipeManager.INSTANCE.getReviveTotemTarget(stack) != null) continue;
            totemSlot = i;
        }
        if (playerHeadUUID == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cMissing: Player Head of a dead player in purgatory"));
            return false;
        }
        if (maceSlot == -1) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cMissing: Mace"));
            return false;
        }
        if (beaconSlot == -1) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cMissing: Beacon"));
            return false;
        }
        if (netherStarSlot == -1) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cMissing: Nether Star"));
            return false;
        }
        if (totemSlot == -1) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cMissing: Totem of Undying"));
            return false;
        }
        PlayerStateData deadPlayerState = PlayerStateManager.INSTANCE.getPlayerState(playerHeadUUID);
        if (deadPlayerState == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cError: Could not find player state"));
            return false;
        }
        inventory.method_5438(playerHeadSlot).method_7934(1);
        inventory.method_5438(maceSlot).method_7934(1);
        inventory.method_5438(beaconSlot).method_7934(1);
        inventory.method_5438(netherStarSlot).method_7934(1);
        inventory.method_5438(totemSlot).method_7934(1);
        class_1799 reviveTotem = ReviveRecipeManager.INSTANCE.createReviveTotem(playerHeadUUID, deadPlayerState.getPlayerName());
        if (!inventory.method_7394(reviveTotem)) {
            player.method_7328(reviveTotem, false);
        }
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7lRevive Totem crafted!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eUse it (right-click) to activate the revival!"));
        logger.info("Revive totem crafted by " + player.method_7334().name() + " for " + deadPlayerState.getPlayerName());
        return true;
    }

    private final UUID getPlayerHeadUUID(class_1799 stack) {
        try {
            class_9296 profile = (class_9296)stack.method_58694(class_9334.field_49617);
            if (profile != null) {
                GameProfile gameProfile = profile.method_73313();
                Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"partialProfile(...)");
                GameProfile partialProfile = gameProfile;
                if (partialProfile.id() != null) {
                    return partialProfile.id();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error getting player head UUID: " + e.getMessage());
        }
        return null;
    }

    private static final class_1269 register$lambda$0(class_1657 player, class_1937 world, class_1268 hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (player instanceof class_3222 && !world.method_8608()) {
            class_1799 class_17992 = player.method_5998(hand);
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getItemInHand(...)");
            class_1799 stack = class_17992;
            UUID targetUUID = ReviveRecipeManager.INSTANCE.getReviveTotemTarget(stack);
            if (targetUUID != null) {
                ReviveRecipeManager.INSTANCE.onReviveTotemUsed(stack, (class_3222)player);
                return (class_1269)class_1269.field_5812;
            }
        }
        return (class_1269)class_1269.field_5811;
    }
}

