/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.DimensionManager;
import revive.mod.GameSessionManager;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.PlayerStatus;
import revive.mod.RestrictedSpectatorManager;
import revive.mod.ReviveTask;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003R\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lrevive/mod/HardcoreModSavedData;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "init", "(Lnet/minecraft/server/MinecraftServer;)V", "save", "load", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "Ljava/io/File;", "dataFile", "Ljava/io/File;", "SavedDataModel", "PlayerStateModel", "ReviveTaskModel", "hardcore-mod"})
@SourceDebugExtension(value={"SMAP\nHardcoreModSavedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HardcoreModSavedData.kt\nrevive/mod/HardcoreModSavedData\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n129#2:180\n158#2,3:181\n129#2:184\n158#2,3:185\n1586#3:188\n1661#3,3:189\n*S KotlinDebug\n*F\n+ 1 HardcoreModSavedData.kt\nrevive/mod/HardcoreModSavedData\n*L\n45#1:180\n45#1:181,3\n54#1:184\n54#1:185,3\n62#1:188\n62#1:189,3\n*E\n"})
public final class HardcoreModSavedData {
    @NotNull
    public static final HardcoreModSavedData INSTANCE = new HardcoreModSavedData();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    private static final Gson gson;
    @Nullable
    private static File dataFile;

    private HardcoreModSavedData() {
    }

    public final void init(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        File overworldFolder = server.method_27050(class_5218.field_24188).toFile();
        File file = dataFile = new File(overworldFolder, "hardcore_mod_data.json");
        logger.info("Data file initialized: " + (file != null ? file.getAbsolutePath() : null));
    }

    /*
     * WARNING - void declaration
     */
    public final void save() {
        File file = dataFile;
        if (file == null) {
            HardcoreModSavedData $this$save_u24lambda_u240 = this;
            boolean bl4 = false;
            logger.error("Cannot save - data file not initialized!");
            return;
        }
        File file2 = file;
        try {
            Collection<String> collection;
            Collection<ReviveTaskModel> collection2;
            UUID uuid;
            Collection<PlayerStateModel> collection3;
            Object object;
            Object $this$mapTo$iv$iv;
            Object $this$map$iv;
            Map<UUID, PlayerStateData> map = PlayerStateManager.INSTANCE.getAllStates();
            boolean bl = DimensionManager.INSTANCE.isDimensionSetup();
            boolean bl2 = GameSessionManager.INSTANCE.isGamePaused();
            long l = GameSessionManager.INSTANCE.getPausedTime();
            long l2 = GameSessionManager.INSTANCE.getStartTime();
            boolean bl3 = GameSessionManager.INSTANCE.isGameActive();
            boolean $i$f$map = false;
            void bl4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                object = entry;
                collection3 = destination$iv$iv;
                boolean bl5 = false;
                uuid = (UUID)object.getKey();
                PlayerStateData state = (PlayerStateData)object.getValue();
                String string = uuid.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection3.add(new PlayerStateModel(string, state.getPlayerName(), state.getStatus().name(), state.getDeathCount(), state.getParkourCompleted()));
            }
            collection3 = (List)destination$iv$iv;
            $this$map$iv = PlayerStateManager.INSTANCE.getAllReviveTasks();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            for (Map.Entry<Object, Object> entry : $this$mapTo$iv$iv.entrySet()) {
                object = entry;
                collection2 = destination$iv$iv;
                boolean bl6 = false;
                uuid = (UUID)object.getKey();
                ReviveTask task = (ReviveTask)object.getValue();
                String string = uuid.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection2.add(new ReviveTaskModel(string, task.getParkourCompleted(), task.getCraftingCompleted(), task.getStartTime()));
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv = RestrictedSpectatorManager.INSTANCE.getAllRestricted();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator<Map.Entry<Object, Object>> iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry<Object, Object> entry = iterator.next();
                object = (UUID)((Object)entry);
                collection = destination$iv$iv;
                boolean bl7 = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(string);
            }
            Collection<String> collection4 = collection = (List)destination$iv$iv;
            Collection<ReviveTaskModel> collection5 = collection2;
            Collection<PlayerStateModel> collection6 = collection3;
            boolean bl5 = bl;
            boolean bl6 = bl2;
            long l3 = l;
            long l4 = l2;
            boolean bl7 = bl3;
            SavedDataModel data = new SavedDataModel(bl7, l4, l3, bl6, bl5, (List<PlayerStateModel>)collection6, (List<ReviveTaskModel>)collection5, (List<String>)collection4);
            String string = gson.toJson((Object)data);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
            logger.info("Saved hardcore mod data: gameActive=" + data.getGameActive() + ", players=" + data.getPlayerStates().size());
        }
        catch (Exception e) {
            logger.error("Failed to save hardcore mod data: " + e.getMessage(), (Throwable)e);
        }
    }

    public final void load() {
        File file = dataFile;
        if (file == null) {
            HardcoreModSavedData $this$load_u24lambda_u240 = this;
            boolean bl = false;
            logger.error("Cannot load - data file not initialized!");
            return;
        }
        File file2 = file;
        if (!file2.exists()) {
            logger.info("No saved data found, starting fresh");
            return;
        }
        try {
            String json = FilesKt.readText$default((File)file2, null, (int)1, null);
            SavedDataModel data = (SavedDataModel)gson.fromJson(json, SavedDataModel.class);
            GameSessionManager.INSTANCE.loadFromSavedData(data.getGameActive(), data.getStartTime(), data.getPausedTime(), data.isPaused());
            Map playerStates = new LinkedHashMap();
            for (PlayerStateModel playerStateModel : data.getPlayerStates()) {
                try {
                    Object object;
                    String string;
                    UUID uUID;
                    UUID uuid = UUID.fromString(playerStateModel.getUuid());
                    Map map = playerStates;
                    Intrinsics.checkNotNull((Object)uuid);
                    String string2 = playerStateModel.getPlayerName();
                    UUID uUID2 = uuid;
                    try {
                        uUID = uUID2;
                        string = string2;
                        object = PlayerStatus.valueOf(playerStateModel.getStatus());
                    }
                    catch (Exception exception) {
                        uUID = uUID2;
                        string = string2;
                        object = PlayerStatus.ALIVE;
                    }
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 224;
                    int n2 = 0;
                    String string3 = null;
                    Triple triple = null;
                    boolean bl = playerStateModel.getParkourCompleted();
                    int n3 = playerStateModel.getDeathCount();
                    PlayerStatus playerStatus = object;
                    String string4 = string;
                    UUID uUID3 = uUID;
                    object = new PlayerStateData(uUID3, string4, playerStatus, n3, bl, triple, string3, n2, n, defaultConstructorMarker);
                    map.put(uuid, object);
                }
                catch (Exception e) {
                    logger.error("Error loading player state: " + e.getMessage());
                }
            }
            Map pendingRevives = new LinkedHashMap();
            for (ReviveTaskModel rt : data.getPendingRevives()) {
                try {
                    UUID uuid = UUID.fromString(rt.getUuid());
                    Intrinsics.checkNotNull((Object)uuid);
                    pendingRevives.put(uuid, new ReviveTask(uuid, rt.getParkourCompleted(), rt.getCraftingCompleted(), rt.getStartTime()));
                }
                catch (Exception e) {
                    logger.error("Error loading revive task: " + e.getMessage());
                }
            }
            PlayerStateManager.INSTANCE.loadFromSavedData(playerStates, pendingRevives);
            Set set = new LinkedHashSet();
            for (String uuidStr : data.getRestrictedSpectators()) {
                try {
                    UUID uUID = UUID.fromString(uuidStr);
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
                    set.add(uUID);
                }
                catch (Exception e) {
                    logger.error("Error loading restricted spectator: " + e.getMessage());
                }
            }
            RestrictedSpectatorManager.INSTANCE.loadFromSavedData(set);
            DimensionManager.INSTANCE.setDimensionSetup(data.getDimensionSetup());
            logger.info("Loaded hardcore mod data: gameActive=" + data.getGameActive() + ", players=" + data.getPlayerStates().size());
        }
        catch (Exception e) {
            logger.error("Failed to load hardcore mod data: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        HardcoreModSavedData.gson = gson;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001b\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013JB\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0017\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0011\u0010\u0019\u001a\u00020\u0006H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0019\u0010\u0011J\u0011\u0010\u001a\u001a\u00020\u0002H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u001a\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001d\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001e\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010\u0011R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010!\u001a\u0004\b\"\u0010\u0013\u00a8\u0006#"}, d2={"Lrevive/mod/HardcoreModSavedData$PlayerStateModel;", "", "", "uuid", "playerName", "status", "", "deathCount", "", "parkourCompleted", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZ)V", "component1", "()Ljava/lang/String;", "component2", "component3", "component4", "()I", "component5", "()Z", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZ)Lrevive/mod/HardcoreModSavedData$PlayerStateModel;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getUuid", "getPlayerName", "getStatus", "I", "getDeathCount", "Z", "getParkourCompleted", "hardcore-mod"})
    public static final class PlayerStateModel {
        @NotNull
        private final String uuid;
        @NotNull
        private final String playerName;
        @NotNull
        private final String status;
        private final int deathCount;
        private final boolean parkourCompleted;

        public PlayerStateModel(@NotNull String uuid, @NotNull String playerName, @NotNull String status, int deathCount, boolean parkourCompleted) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.uuid = uuid;
            this.playerName = playerName;
            this.status = status;
            this.deathCount = deathCount;
            this.parkourCompleted = parkourCompleted;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        @NotNull
        public final String getPlayerName() {
            return this.playerName;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        public final int getDeathCount() {
            return this.deathCount;
        }

        public final boolean getParkourCompleted() {
            return this.parkourCompleted;
        }

        @NotNull
        public final String component1() {
            return this.uuid;
        }

        @NotNull
        public final String component2() {
            return this.playerName;
        }

        @NotNull
        public final String component3() {
            return this.status;
        }

        public final int component4() {
            return this.deathCount;
        }

        public final boolean component5() {
            return this.parkourCompleted;
        }

        @NotNull
        public final PlayerStateModel copy(@NotNull String uuid, @NotNull String playerName, @NotNull String status, int deathCount, boolean parkourCompleted) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return new PlayerStateModel(uuid, playerName, status, deathCount, parkourCompleted);
        }

        public static /* synthetic */ PlayerStateModel copy$default(PlayerStateModel playerStateModel, String string, String string2, String string3, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = playerStateModel.uuid;
            }
            if ((n2 & 2) != 0) {
                string2 = playerStateModel.playerName;
            }
            if ((n2 & 4) != 0) {
                string3 = playerStateModel.status;
            }
            if ((n2 & 8) != 0) {
                n = playerStateModel.deathCount;
            }
            if ((n2 & 0x10) != 0) {
                bl = playerStateModel.parkourCompleted;
            }
            return playerStateModel.copy(string, string2, string3, n, bl);
        }

        @NotNull
        public String toString() {
            return "PlayerStateModel(uuid=" + this.uuid + ", playerName=" + this.playerName + ", status=" + this.status + ", deathCount=" + this.deathCount + ", parkourCompleted=" + this.parkourCompleted + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.playerName.hashCode();
            result = result * 31 + this.status.hashCode();
            result = result * 31 + Integer.hashCode(this.deathCount);
            result = result * 31 + Boolean.hashCode(this.parkourCompleted);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlayerStateModel)) {
                return false;
            }
            PlayerStateModel playerStateModel = (PlayerStateModel)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)playerStateModel.uuid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.playerName, (Object)playerStateModel.playerName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.status, (Object)playerStateModel.status)) {
                return false;
            }
            if (this.deathCount != playerStateModel.deathCount) {
                return false;
            }
            return this.parkourCompleted == playerStateModel.parkourCompleted;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0018\u001a\u00020\u0017H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0011\u0010\u001a\u001a\u00020\u0002H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u001a\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001f\u0010\u000eR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b!\u0010\u0011\u00a8\u0006\""}, d2={"Lrevive/mod/HardcoreModSavedData$ReviveTaskModel;", "", "", "uuid", "", "parkourCompleted", "craftingCompleted", "", "startTime", "<init>", "(Ljava/lang/String;ZZJ)V", "component1", "()Ljava/lang/String;", "component2", "()Z", "component3", "component4", "()J", "copy", "(Ljava/lang/String;ZZJ)Lrevive/mod/HardcoreModSavedData$ReviveTaskModel;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getUuid", "Z", "getParkourCompleted", "getCraftingCompleted", "J", "getStartTime", "hardcore-mod"})
    public static final class ReviveTaskModel {
        @NotNull
        private final String uuid;
        private final boolean parkourCompleted;
        private final boolean craftingCompleted;
        private final long startTime;

        public ReviveTaskModel(@NotNull String uuid, boolean parkourCompleted, boolean craftingCompleted, long startTime) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.uuid = uuid;
            this.parkourCompleted = parkourCompleted;
            this.craftingCompleted = craftingCompleted;
            this.startTime = startTime;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        public final boolean getParkourCompleted() {
            return this.parkourCompleted;
        }

        public final boolean getCraftingCompleted() {
            return this.craftingCompleted;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        @NotNull
        public final String component1() {
            return this.uuid;
        }

        public final boolean component2() {
            return this.parkourCompleted;
        }

        public final boolean component3() {
            return this.craftingCompleted;
        }

        public final long component4() {
            return this.startTime;
        }

        @NotNull
        public final ReviveTaskModel copy(@NotNull String uuid, boolean parkourCompleted, boolean craftingCompleted, long startTime) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new ReviveTaskModel(uuid, parkourCompleted, craftingCompleted, startTime);
        }

        public static /* synthetic */ ReviveTaskModel copy$default(ReviveTaskModel reviveTaskModel, String string, boolean bl, boolean bl2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = reviveTaskModel.uuid;
            }
            if ((n & 2) != 0) {
                bl = reviveTaskModel.parkourCompleted;
            }
            if ((n & 4) != 0) {
                bl2 = reviveTaskModel.craftingCompleted;
            }
            if ((n & 8) != 0) {
                l = reviveTaskModel.startTime;
            }
            return reviveTaskModel.copy(string, bl, bl2, l);
        }

        @NotNull
        public String toString() {
            return "ReviveTaskModel(uuid=" + this.uuid + ", parkourCompleted=" + this.parkourCompleted + ", craftingCompleted=" + this.craftingCompleted + ", startTime=" + this.startTime + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + Boolean.hashCode(this.parkourCompleted);
            result = result * 31 + Boolean.hashCode(this.craftingCompleted);
            result = result * 31 + Long.hashCode(this.startTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReviveTaskModel)) {
                return false;
            }
            ReviveTaskModel reviveTaskModel = (ReviveTaskModel)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)reviveTaskModel.uuid)) {
                return false;
            }
            if (this.parkourCompleted != reviveTaskModel.parkourCompleted) {
                return false;
            }
            if (this.craftingCompleted != reviveTaskModel.craftingCompleted) {
                return false;
            }
            return this.startTime == reviveTaskModel.startTime;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001Bi\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u0010\u0010\u0018\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0013J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001aJr\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00022\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u00c6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001b\u0010 \u001a\u00020\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004\u00a2\u0006\u0004\b \u0010!J\u0011\u0010#\u001a\u00020\"H\u00d6\u0081\u0004\u00a2\u0006\u0004\b#\u0010$J\u0011\u0010%\u001a\u00020\u000eH\u00d6\u0081\u0004\u00a2\u0006\u0004\b%\u0010&R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010\u0013R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010\u0015R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010)\u001a\u0004\b+\u0010\u0015R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010'\u001a\u0004\b\u0007\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010'\u001a\u0004\b,\u0010\u0013R\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010-\u001a\u0004\b.\u0010\u001aR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010-\u001a\u0004\b/\u0010\u001aR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010-\u001a\u0004\b0\u0010\u001a\u00a8\u00061"}, d2={"Lrevive/mod/HardcoreModSavedData$SavedDataModel;", "", "", "gameActive", "", "startTime", "pausedTime", "isPaused", "dimensionSetup", "", "Lrevive/mod/HardcoreModSavedData$PlayerStateModel;", "playerStates", "Lrevive/mod/HardcoreModSavedData$ReviveTaskModel;", "pendingRevives", "", "restrictedSpectators", "<init>", "(ZJJZZLjava/util/List;Ljava/util/List;Ljava/util/List;)V", "component1", "()Z", "component2", "()J", "component3", "component4", "component5", "component6", "()Ljava/util/List;", "component7", "component8", "copy", "(ZJJZZLjava/util/List;Ljava/util/List;Ljava/util/List;)Lrevive/mod/HardcoreModSavedData$SavedDataModel;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Z", "getGameActive", "J", "getStartTime", "getPausedTime", "getDimensionSetup", "Ljava/util/List;", "getPlayerStates", "getPendingRevives", "getRestrictedSpectators", "hardcore-mod"})
    public static final class SavedDataModel {
        private final boolean gameActive;
        private final long startTime;
        private final long pausedTime;
        private final boolean isPaused;
        private final boolean dimensionSetup;
        @NotNull
        private final List<PlayerStateModel> playerStates;
        @NotNull
        private final List<ReviveTaskModel> pendingRevives;
        @NotNull
        private final List<String> restrictedSpectators;

        public SavedDataModel(boolean gameActive, long startTime, long pausedTime, boolean isPaused, boolean dimensionSetup, @NotNull List<PlayerStateModel> playerStates, @NotNull List<ReviveTaskModel> pendingRevives, @NotNull List<String> restrictedSpectators) {
            Intrinsics.checkNotNullParameter(playerStates, (String)"playerStates");
            Intrinsics.checkNotNullParameter(pendingRevives, (String)"pendingRevives");
            Intrinsics.checkNotNullParameter(restrictedSpectators, (String)"restrictedSpectators");
            this.gameActive = gameActive;
            this.startTime = startTime;
            this.pausedTime = pausedTime;
            this.isPaused = isPaused;
            this.dimensionSetup = dimensionSetup;
            this.playerStates = playerStates;
            this.pendingRevives = pendingRevives;
            this.restrictedSpectators = restrictedSpectators;
        }

        public /* synthetic */ SavedDataModel(boolean bl, long l, long l2, boolean bl2, boolean bl3, List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                l = 0L;
            }
            if ((n & 4) != 0) {
                l2 = 0L;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            if ((n & 0x20) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 0x40) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x80) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            this(bl, l, l2, bl2, bl3, list, list2, list3);
        }

        public final boolean getGameActive() {
            return this.gameActive;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final long getPausedTime() {
            return this.pausedTime;
        }

        public final boolean isPaused() {
            return this.isPaused;
        }

        public final boolean getDimensionSetup() {
            return this.dimensionSetup;
        }

        @NotNull
        public final List<PlayerStateModel> getPlayerStates() {
            return this.playerStates;
        }

        @NotNull
        public final List<ReviveTaskModel> getPendingRevives() {
            return this.pendingRevives;
        }

        @NotNull
        public final List<String> getRestrictedSpectators() {
            return this.restrictedSpectators;
        }

        public final boolean component1() {
            return this.gameActive;
        }

        public final long component2() {
            return this.startTime;
        }

        public final long component3() {
            return this.pausedTime;
        }

        public final boolean component4() {
            return this.isPaused;
        }

        public final boolean component5() {
            return this.dimensionSetup;
        }

        @NotNull
        public final List<PlayerStateModel> component6() {
            return this.playerStates;
        }

        @NotNull
        public final List<ReviveTaskModel> component7() {
            return this.pendingRevives;
        }

        @NotNull
        public final List<String> component8() {
            return this.restrictedSpectators;
        }

        @NotNull
        public final SavedDataModel copy(boolean gameActive, long startTime, long pausedTime, boolean isPaused, boolean dimensionSetup, @NotNull List<PlayerStateModel> playerStates, @NotNull List<ReviveTaskModel> pendingRevives, @NotNull List<String> restrictedSpectators) {
            Intrinsics.checkNotNullParameter(playerStates, (String)"playerStates");
            Intrinsics.checkNotNullParameter(pendingRevives, (String)"pendingRevives");
            Intrinsics.checkNotNullParameter(restrictedSpectators, (String)"restrictedSpectators");
            return new SavedDataModel(gameActive, startTime, pausedTime, isPaused, dimensionSetup, playerStates, pendingRevives, restrictedSpectators);
        }

        public static /* synthetic */ SavedDataModel copy$default(SavedDataModel savedDataModel, boolean bl, long l, long l2, boolean bl2, boolean bl3, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = savedDataModel.gameActive;
            }
            if ((n & 2) != 0) {
                l = savedDataModel.startTime;
            }
            if ((n & 4) != 0) {
                l2 = savedDataModel.pausedTime;
            }
            if ((n & 8) != 0) {
                bl2 = savedDataModel.isPaused;
            }
            if ((n & 0x10) != 0) {
                bl3 = savedDataModel.dimensionSetup;
            }
            if ((n & 0x20) != 0) {
                list = savedDataModel.playerStates;
            }
            if ((n & 0x40) != 0) {
                list2 = savedDataModel.pendingRevives;
            }
            if ((n & 0x80) != 0) {
                list3 = savedDataModel.restrictedSpectators;
            }
            return savedDataModel.copy(bl, l, l2, bl2, bl3, list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "SavedDataModel(gameActive=" + this.gameActive + ", startTime=" + this.startTime + ", pausedTime=" + this.pausedTime + ", isPaused=" + this.isPaused + ", dimensionSetup=" + this.dimensionSetup + ", playerStates=" + this.playerStates + ", pendingRevives=" + this.pendingRevives + ", restrictedSpectators=" + this.restrictedSpectators + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.gameActive);
            result = result * 31 + Long.hashCode(this.startTime);
            result = result * 31 + Long.hashCode(this.pausedTime);
            result = result * 31 + Boolean.hashCode(this.isPaused);
            result = result * 31 + Boolean.hashCode(this.dimensionSetup);
            result = result * 31 + ((Object)this.playerStates).hashCode();
            result = result * 31 + ((Object)this.pendingRevives).hashCode();
            result = result * 31 + ((Object)this.restrictedSpectators).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SavedDataModel)) {
                return false;
            }
            SavedDataModel savedDataModel = (SavedDataModel)other;
            if (this.gameActive != savedDataModel.gameActive) {
                return false;
            }
            if (this.startTime != savedDataModel.startTime) {
                return false;
            }
            if (this.pausedTime != savedDataModel.pausedTime) {
                return false;
            }
            if (this.isPaused != savedDataModel.isPaused) {
                return false;
            }
            if (this.dimensionSetup != savedDataModel.dimensionSetup) {
                return false;
            }
            if (!Intrinsics.areEqual(this.playerStates, savedDataModel.playerStates)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pendingRevives, savedDataModel.pendingRevives)) {
                return false;
            }
            return Intrinsics.areEqual(this.restrictedSpectators, savedDataModel.restrictedSpectators);
        }

        public SavedDataModel() {
            this(false, 0L, 0L, false, false, null, null, null, 255, null);
        }
    }
}

