/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.GameSessionManager;
import revive.mod.GraveManager;
import revive.mod.HardcoreCommands;
import revive.mod.HardcoreModSavedData;
import revive.mod.NetworkHandler;
import revive.mod.PlayerStateManager;
import revive.mod.ReviveCraftingHandler;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u001c\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lrevive/mod/HardcoreMod;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "MOD_ID", "Ljava/lang/String;", "", "tickCounter", "I", "STATUS_UPDATE_INTERVAL", "saveTickCounter", "SAVE_INTERVAL", "hardcore-mod"})
public final class HardcoreMod
implements ModInitializer {
    @NotNull
    public static final HardcoreMod INSTANCE = new HardcoreMod();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    public static final String MOD_ID = "hardcore-mod";
    private static int tickCounter;
    private static final int STATUS_UPDATE_INTERVAL = 20;
    private static int saveTickCounter;
    private static final int SAVE_INTERVAL = 6000;

    private HardcoreMod() {
    }

    public void onInitialize() {
        logger.info("Initializing Hardcore Revival Mod...");
        NetworkHandler.INSTANCE.registerServer();
        logger.info("Network handlers registered");
        HardcoreCommands.INSTANCE.register();
        logger.info("Commands registered");
        ReviveCraftingHandler.INSTANCE.register();
        logger.info("Revive crafting handler registered");
        UseBlockCallback.EVENT.register(HardcoreMod::onInitialize$lambda$0);
        logger.info("Grave interaction handler registered");
        ServerPlayConnectionEvents.JOIN.register(HardcoreMod::onInitialize$lambda$1);
        ServerPlayConnectionEvents.DISCONNECT.register(HardcoreMod::onInitialize$lambda$2);
        ServerTickEvents.END_SERVER_TICK.register(HardcoreMod::onInitialize$lambda$3);
        ServerLifecycleEvents.SERVER_STOPPING.register(HardcoreMod::onInitialize$lambda$4);
        ServerLifecycleEvents.SERVER_STARTED.register(HardcoreMod::onInitialize$lambda$5);
        logger.info("Hardcore Revival Mod initialized successfully!");
        logger.info("Commands available: /hardcore setup, /hardcore status, /hardcore reset, /hardcore revive <player>");
        logger.info("Player commands: /revive craft, /revive help");
    }

    private static final class_1269 onInitialize$lambda$0(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!world.method_8608() && player instanceof class_3222) {
            boolean success;
            class_2338 class_23382 = hitResult.method_17777();
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getBlockPos(...)");
            class_2338 pos = class_23382;
            class_2680 class_26802 = world.method_8320(pos);
            Intrinsics.checkNotNullExpressionValue((Object)class_26802, (String)"getBlockState(...)");
            class_2680 blockState = class_26802;
            if (blockState.method_27852(class_2246.field_10432) && GraveManager.INSTANCE.isGravePosition(pos) && (success = GraveManager.INSTANCE.onGraveInteract((class_3222)player, pos))) {
                return (class_1269)class_1269.field_5812;
            }
        }
        return (class_1269)class_1269.field_5811;
    }

    private static final void onInitialize$lambda$1(class_3244 handler, PacketSender sender, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3222 class_32222 = handler.field_14140;
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player");
        class_3222 player = class_32222;
        PlayerStateManager.INSTANCE.updatePlayerName(player);
        logger.info("Player " + player.method_7334().name() + " joined, tracking state");
        NetworkHandler.INSTANCE.sendStatusUpdate(player);
    }

    private static final void onInitialize$lambda$2(class_3244 handler, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        logger.info("Player " + handler.field_14140.method_7334().name() + " disconnected");
    }

    private static final void onInitialize$lambda$3(MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (GameSessionManager.INSTANCE.isGameActive()) {
            int n = tickCounter;
            if ((tickCounter = n + 1) >= 20) {
                tickCounter = 0;
                NetworkHandler.INSTANCE.broadcastStatusUpdates(server);
            }
            if ((saveTickCounter = (n = saveTickCounter) + 1) >= 6000) {
                saveTickCounter = 0;
                HardcoreModSavedData.INSTANCE.save();
                logger.debug("Auto-saved hardcore mod data");
            }
        }
    }

    private static final void onInitialize$lambda$4(MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        logger.info("Server stopping, saving hardcore mod data...");
        HardcoreModSavedData.INSTANCE.save();
        logger.info("Hardcore mod data saved!");
    }

    private static final void onInitialize$lambda$5(MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        logger.info("Server started! Loading hardcore mod data...");
        HardcoreModSavedData.INSTANCE.init(server);
        HardcoreModSavedData.INSTANCE.load();
        if (GameSessionManager.INSTANCE.isGameActive()) {
            logger.info("Restored active game session!");
        }
        logger.info("Use /hardcore setup to initialize the purgatory dimension.");
    }
}

