/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.DimensionManager;
import revive.mod.NetworkHandler;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.RestrictedSpectatorManager;
import revive.mod.SessionStats;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u0015\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0012J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0019\u0010\u0012J\u001f\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u001b\u00a2\u0006\u0004\b!\u0010\u0003J\r\u0010\"\u001a\u00020\b\u00a2\u0006\u0004\b\"\u0010\nJ\r\u0010#\u001a\u00020\b\u00a2\u0006\u0004\b#\u0010\nJ-\u0010(\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0004\u00a2\u0006\u0004\b(\u0010)R\u001c\u0010,\u001a\n +*\u0004\u0018\u00010*0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00104\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00103R\u0014\u00105\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00100\u00a8\u00066"}, d2={"Lrevive/mod/GameSessionManager;", "", "<init>", "()V", "", "isGameActive", "()Z", "isGamePaused", "", "getElapsedTimeMs", "()J", "", "getFormattedTime", "()Ljava/lang/String;", "getFormattedTimeColored", "Lnet/minecraft/server/MinecraftServer;", "server", "startGame", "(Lnet/minecraft/server/MinecraftServer;)Z", "reason", "stopGame", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;)Z", "pauseGame", "resumeGame", "checkGameOver", "checkVictory", "message", "", "broadcastMessage", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;)V", "Lrevive/mod/SessionStats;", "getStats", "()Lrevive/mod/SessionStats;", "reset", "getStartTime", "getPausedTime", "active", "start", "paused", "pausedState", "loadFromSavedData", "(ZJJZ)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "gameActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Ljava/util/concurrent/atomic/AtomicLong;", "startTime", "Ljava/util/concurrent/atomic/AtomicLong;", "pausedTime", "isPaused", "hardcore-mod"})
@SourceDebugExtension(value={"SMAP\nGameSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameSessionManager.kt\nrevive/mod/GameSessionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1915#2,2:279\n1915#2,2:281\n1915#2,2:283\n1915#2,2:285\n*S KotlinDebug\n*F\n+ 1 GameSessionManager.kt\nrevive/mod/GameSessionManager\n*L\n86#1:279,2\n115#1:281,2\n152#1:283,2\n218#1:285,2\n*E\n"})
public final class GameSessionManager {
    @NotNull
    public static final GameSessionManager INSTANCE = new GameSessionManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    private static final AtomicBoolean gameActive = new AtomicBoolean(false);
    @NotNull
    private static final AtomicLong startTime = new AtomicLong(0L);
    @NotNull
    private static final AtomicLong pausedTime = new AtomicLong(0L);
    @NotNull
    private static final AtomicBoolean isPaused = new AtomicBoolean(false);

    private GameSessionManager() {
    }

    public final boolean isGameActive() {
        return gameActive.get();
    }

    public final boolean isGamePaused() {
        return isPaused.get();
    }

    public final long getElapsedTimeMs() {
        if (!gameActive.get()) {
            return 0L;
        }
        return isPaused.get() ? pausedTime.get() : System.currentTimeMillis() - startTime.get();
    }

    @NotNull
    public final String getFormattedTime() {
        long totalSeconds = this.getElapsedTimeMs() / (long)1000;
        long hours = totalSeconds / (long)3600;
        long minutes = totalSeconds % (long)3600 / (long)60;
        long seconds = totalSeconds % (long)60;
        String string = "%02d:%02d:%02d";
        Object[] objectArray = new Object[]{hours, minutes, seconds};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String getFormattedTimeColored() {
        String time = this.getFormattedTime();
        return "\u00a7e" + time;
    }

    public final boolean startGame(@NotNull MinecraftServer server) {
        class_3222 player;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (gameActive.get()) {
            logger.warn("Game already active!");
            return false;
        }
        if (!DimensionManager.INSTANCE.isDimensionSetup()) {
            logger.warn("Purgatory dimension not set up! Run /hardcore setup first.");
            return false;
        }
        PlayerStateManager.INSTANCE.resetAll();
        RestrictedSpectatorManager.INSTANCE.reset();
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            player = (class_3222)element$iv;
            boolean bl = false;
            player.method_7336(class_1934.field_9215);
            player.method_6033(player.method_6063());
            player.method_7344().method_7580(20);
            player.method_7344().method_7581(5.0f);
            player.method_6012();
        }
        startTime.set(System.currentTimeMillis());
        pausedTime.set(0L);
        isPaused.set(false);
        gameActive.set(true);
        this.broadcastMessage(server, "\u00a76\u00a7l================================");
        this.broadcastMessage(server, "\u00a7c\u00a7l   HARDCORE MODE STARTED!");
        this.broadcastMessage(server, "\u00a76\u00a7l================================");
        this.broadcastMessage(server, "");
        this.broadcastMessage(server, "\u00a7eRules:");
        this.broadcastMessage(server, "\u00a77- 1st Death: Parkour in Purgatory");
        this.broadcastMessage(server, "\u00a77- 2nd Death: Permanent Spectator");
        this.broadcastMessage(server, "\u00a77- Teamwork is key!");
        this.broadcastMessage(server, "");
        this.broadcastMessage(server, "\u00a7aGood luck!");
        List list2 = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPlayers(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            player = (class_3222)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            NetworkHandler.INSTANCE.sendStatusUpdate(player);
        }
        logger.info("Hardcore game session started!");
        return true;
    }

    public final boolean stopGame(@NotNull MinecraftServer server, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!gameActive.get()) {
            logger.warn("No game active!");
            return false;
        }
        String finalTime = this.getFormattedTime();
        gameActive.set(false);
        this.broadcastMessage(server, "\u00a76\u00a7l================================");
        this.broadcastMessage(server, "\u00a7c\u00a7l   HARDCORE MODE ENDED!");
        this.broadcastMessage(server, "\u00a76\u00a7l================================");
        this.broadcastMessage(server, "");
        this.broadcastMessage(server, "\u00a7eReason: \u00a7f" + reason);
        this.broadcastMessage(server, "\u00a7eGame time: \u00a7f" + finalTime);
        this.broadcastMessage(server, "");
        List<PlayerStateData> alivePlayers = PlayerStateManager.INSTANCE.getAlivePlayers();
        List<PlayerStateData> purgatoryPlayers = PlayerStateManager.INSTANCE.getPlayersInPurgatory();
        this.broadcastMessage(server, "\u00a7aSurvivors: \u00a7f" + alivePlayers.size());
        this.broadcastMessage(server, "\u00a7eIn Purgatory: \u00a7f" + purgatoryPlayers.size());
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            player.method_7336(class_1934.field_9215);
            Intrinsics.checkNotNull((Object)player);
            RestrictedSpectatorManager.INSTANCE.disableRestrictedMode(player);
        }
        logger.info("Hardcore game session stopped. Final time: " + finalTime);
        return true;
    }

    public static /* synthetic */ boolean stopGame$default(GameSessionManager gameSessionManager, MinecraftServer minecraftServer, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "Admin";
        }
        return gameSessionManager.stopGame(minecraftServer, string);
    }

    public final boolean pauseGame(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!gameActive.get() || isPaused.get()) {
            return false;
        }
        pausedTime.set(System.currentTimeMillis() - startTime.get());
        isPaused.set(true);
        this.broadcastMessage(server, "\u00a7e\u00a7l[PAUSED] \u00a7fGame paused at " + this.getFormattedTime());
        return true;
    }

    public final boolean resumeGame(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!gameActive.get() || !isPaused.get()) {
            return false;
        }
        startTime.set(System.currentTimeMillis() - pausedTime.get());
        isPaused.set(false);
        this.broadcastMessage(server, "\u00a7a\u00a7l[RESUMED] \u00a7fGame resumed!");
        return true;
    }

    public final boolean checkGameOver(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!gameActive.get()) {
            return false;
        }
        List<PlayerStateData> alivePlayers = PlayerStateManager.INSTANCE.getAlivePlayers();
        List<PlayerStateData> purgatoryPlayers = PlayerStateManager.INSTANCE.getPlayersInPurgatory();
        if (alivePlayers.isEmpty() && purgatoryPlayers.isEmpty()) {
            this.stopGame(server, "All players eliminated!");
            return true;
        }
        return false;
    }

    public final boolean checkVictory(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return false;
    }

    private final void broadcastMessage(MinecraftServer server, String message) {
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            player.method_64398((class_2561)class_2561.method_43470((String)message));
        }
    }

    @NotNull
    public final SessionStats getStats() {
        return new SessionStats(gameActive.get(), isPaused.get(), this.getFormattedTime(), PlayerStateManager.INSTANCE.getAlivePlayers().size(), PlayerStateManager.INSTANCE.getPlayersInPurgatory().size());
    }

    public final void reset() {
        gameActive.set(false);
        startTime.set(0L);
        pausedTime.set(0L);
        isPaused.set(false);
    }

    public final long getStartTime() {
        return startTime.get();
    }

    public final long getPausedTime() {
        return pausedTime.get();
    }

    public final void loadFromSavedData(boolean active, long start, long paused, boolean pausedState) {
        gameActive.set(active);
        startTime.set(start);
        pausedTime.set(paused);
        isPaused.set(pausedState);
        logger.info("Loaded game session state: active=" + active + ", paused=" + pausedState);
    }
}

