/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1324;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import revive.mod.DimensionManager;
import revive.mod.GameSessionManager;
import revive.mod.GraveManager;
import revive.mod.NetworkHandler;
import revive.mod.PlayerStateData;
import revive.mod.PlayerStateManager;
import revive.mod.PlayerStatus;
import revive.mod.RestrictedSpectatorManager;
import revive.mod.ReviveTask;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000bJ\u001f\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u000bJ\u0017\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000bJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\bJ\u001d\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010#\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b%\u0010\bJ\u0015\u0010&\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010\u000bJ\u001d\u0010(\u001a\u00020\t2\u0006\u0010'\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010*\u001a\u00020\t2\u0006\u0010'\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b*\u0010)J\u0017\u0010+\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b+\u0010\u000bR\u001c\u0010.\u001a\n -*\u0004\u0018\u00010,0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R \u00102\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u000201008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00104\u001a\u0002018\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00066"}, d2={"Lrevive/mod/DeathHandler;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "hasSpawnProtection", "(Lnet/minecraft/class_3222;)Z", "", "grantSpawnProtection", "(Lnet/minecraft/class_3222;)V", "Ljava/util/UUID;", "playerUuid", "clearSpawnProtection", "(Ljava/util/UUID;)V", "Lnet/minecraft/class_1282;", "damageSource", "handleDeath", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1282;)Z", "handleFirstDeath", "deadPlayer", "Lnet/minecraft/server/MinecraftServer;", "server", "broadcastDeathNotification", "(Lnet/minecraft/class_3222;Lnet/minecraft/server/MinecraftServer;)V", "storeItemsInGrave", "handleSecondDeath", "handlePurgatoryDeath", "Lrevive/mod/PlayerStateData;", "state", "applyMaxHealth", "(Lnet/minecraft/class_3222;Lrevive/mod/PlayerStateData;)V", "", "amount", "restoreHearts", "(Lnet/minecraft/class_3222;I)I", "isInPurgatoryDimension", "onParkourComplete", "deadPlayerUuid", "onReviveItemCrafted", "(Ljava/util/UUID;Lnet/minecraft/server/MinecraftServer;)V", "checkAndCompleteRevive", "revivePlayer", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "", "spawnProtectedPlayers", "Ljava/util/Map;", "SPAWN_PROTECTION_DURATION_MS", "J", "hardcore-mod"})
public final class DeathHandler {
    @NotNull
    public static final DeathHandler INSTANCE = new DeathHandler();
    private static final Logger logger = LoggerFactory.getLogger((String)"hardcore-mod");
    @NotNull
    private static final Map<UUID, Long> spawnProtectedPlayers = new LinkedHashMap();
    private static final long SPAWN_PROTECTION_DURATION_MS = 10000L;

    private DeathHandler() {
    }

    public final boolean hasSpawnProtection(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Long l = spawnProtectedPlayers.get(player.method_5667());
        if (l == null) {
            return false;
        }
        long protectedUntil = l;
        if (System.currentTimeMillis() < protectedUntil) {
            return true;
        }
        spawnProtectedPlayers.remove(player.method_5667());
        return false;
    }

    public final void grantSpawnProtection(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        spawnProtectedPlayers.put(player.method_5667(), System.currentTimeMillis() + 10000L);
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7lYou have 10 seconds of spawn protection!"));
        logger.info("Granted spawn protection to " + player.method_7334().name());
    }

    public final void clearSpawnProtection(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        spawnProtectedPlayers.remove(playerUuid);
    }

    public final boolean handleDeath(@NotNull class_3222 player, @NotNull class_1282 damageSource) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (!GameSessionManager.INSTANCE.isGameActive()) {
            logger.info("Game not active - allowing normal death for " + player.method_7334().name());
            return false;
        }
        if (this.hasSpawnProtection(player)) {
            logger.info("Player " + player.method_7334().name() + " has spawn protection - cancelling death");
            player.method_6033(player.method_6063());
            return true;
        }
        if (this.isInPurgatoryDimension(player)) {
            return this.handlePurgatoryDeath(player);
        }
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        PlayerStatus newStatus = PlayerStateManager.INSTANCE.recordDeath(player);
        logger.info("Player " + player.method_7334().name() + " died. Death count: " + state.getDeathCount() + ", New status: " + newStatus);
        return switch (WhenMappings.$EnumSwitchMapping$0[newStatus.ordinal()]) {
            case 1 -> {
                this.handleFirstDeath(player);
                yield true;
            }
            case 2 -> {
                this.handleSecondDeath(player);
                yield true;
            }
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void handleFirstDeath(class_3222 player) {
        logger.info("First death for " + player.method_7334().name() + " - sending to purgatory");
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        class_2338 class_23382 = player.method_24515();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"blockPosition(...)");
        class_2338 deathPos = class_23382;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerStateManager.INSTANCE.startReviveTask(uUID);
        this.broadcastDeathNotification(player, server);
        GraveManager.INSTANCE.createGrave(player, deathPos);
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lYou died!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eYou have been teleported to the Purgatory dimension."));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eComplete the parkour while your teammates craft the revive item!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Your items are stored in your grave. Collect them after revival!"));
        this.storeItemsInGrave(player);
        player.method_6033(player.method_6063());
        player.method_7344().method_7580(20);
        player.method_7344().method_7581(5.0f);
        DimensionManager.INSTANCE.teleportToPurgatory(player);
        NetworkHandler.INSTANCE.sendStatusUpdate(player);
        NetworkHandler.INSTANCE.broadcastStatusUpdates(server);
    }

    private final void broadcastDeathNotification(class_3222 deadPlayer, MinecraftServer server) {
        String deadPlayerName = deadPlayer.method_7334().name();
        class_2338 class_23382 = deadPlayer.method_24515();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"blockPosition(...)");
        class_2338 deathPos = class_23382;
        for (Object e : server.method_3760().method_14571()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            class_3222 p = (class_3222)e;
            p.method_64398((class_2561)class_2561.method_43470((String)""));
            p.method_64398((class_2561)class_2561.method_43470((String)"\u00a74\u00a7l\u2620 \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 \u2620"));
            p.method_64398((class_2561)class_2561.method_43470((String)("\u00a7c\u00a7l   " + deadPlayerName + " HAS FALLEN!")));
            p.method_64398((class_2561)class_2561.method_43470((String)"\u00a74\u00a7l\u2620 \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 \u2620"));
            p.method_64398((class_2561)class_2561.method_43470((String)""));
            p.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)class_3417.field_14865), class_3419.field_15252, p.method_23317(), p.method_23318(), p.method_23321(), 1.0f, 1.0f, p.method_51469().field_9229.method_43055()));
            PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(p);
            if (state.getStatus() != PlayerStatus.ALIVE || Intrinsics.areEqual((Object)p.method_5667(), (Object)deadPlayer.method_5667())) continue;
            p.method_64398((class_2561)class_2561.method_43470((String)("\u00a76Their grave is at: \u00a7eX=" + deathPos.method_10263() + ", Y=" + deathPos.method_10264() + ", Z=" + deathPos.method_10260())));
            p.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Collect their head and craft the revive totem!"));
            p.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7f/revive help\u00a77 for crafting info."));
        }
    }

    private final void storeItemsInGrave(class_3222 player) {
        class_1661 class_16612 = player.method_31548();
        Intrinsics.checkNotNullExpressionValue((Object)class_16612, (String)"getInventory(...)");
        class_1661 inventory = class_16612;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        UUID playerUUID = uUID;
        int itemCount = 0;
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 stack;
            Intrinsics.checkNotNullExpressionValue((Object)inventory.method_5438(i), (String)"getItem(...)");
            if (stack.method_7960()) continue;
            GraveManager.INSTANCE.storeItemInGrave(playerUUID, stack);
            ++itemCount;
            inventory.method_5447(i, class_1799.field_8037);
        }
        logger.info("Stored " + itemCount + " items in grave for " + player.method_7334().name());
    }

    private final void handleSecondDeath(class_3222 player) {
        logger.info("Second death for " + player.method_7334().name() + " - entering restricted spectator mode");
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a74\u00a7lYou have permanently died!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou are now in restricted spectator mode."));
        player.method_7336(class_1934.field_9219);
        RestrictedSpectatorManager.INSTANCE.enableRestrictedMode(player);
        NetworkHandler.INSTANCE.sendStatusUpdate(player);
    }

    private final boolean handlePurgatoryDeath(class_3222 player) {
        logger.info("Player " + player.method_7334().name() + " died in purgatory - losing a heart and resetting to start");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        int n = state.getLostHearts();
        state.setLostHearts(n + 1);
        int heartsRemaining = 10 - state.getLostHearts();
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lYou fell! -1 Heart permanently!"));
        player.method_64398((class_2561)class_2561.method_43470((String)("\u00a74Hearts remaining: \u00a7c" + heartsRemaining + "\u00a74/10")));
        if (state.hasNoHeartsLeft()) {
            logger.info("Player " + player.method_7334().name() + " has no hearts left - entering spectator mode");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a74\u00a7lYou have lost all your hearts!"));
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou are now in restricted spectator mode."));
            state.setStatus(PlayerStatus.SPECTATOR);
            player.method_7336(class_1934.field_9219);
            RestrictedSpectatorManager.INSTANCE.enableRestrictedMode(player);
            DimensionManager.INSTANCE.teleportToOverworld(player);
            NetworkHandler.INSTANCE.sendStatusUpdate(player);
            MinecraftServer minecraftServer = player.method_51469().method_8503();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            MinecraftServer server = minecraftServer;
            for (Object e : server.method_3760().method_14571()) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                class_3222 p = (class_3222)e;
                p.method_64398((class_2561)class_2561.method_43470((String)("\u00a74" + player.method_7334().name() + " has lost all their hearts and is now a spectator!")));
            }
            return true;
        }
        this.applyMaxHealth(player, state);
        player.method_6033(state.getMaxHealth());
        player.method_7344().method_7580(20);
        player.method_5646();
        DimensionManager.INSTANCE.resetToParkourStart(player);
        return true;
    }

    public final void applyMaxHealth(@NotNull class_3222 player, @NotNull PlayerStateData state) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        float maxHealth = state.getMaxHealth();
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        if (healthAttribute != null) {
            healthAttribute.method_6192((double)maxHealth);
        }
        if (player.method_6032() > maxHealth) {
            player.method_6033(maxHealth);
        }
    }

    public final int restoreHearts(@NotNull class_3222 player, int amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        int oldLostHearts = state.getLostHearts();
        state.setLostHearts(RangesKt.coerceAtLeast((int)(state.getLostHearts() - amount), (int)0));
        int restored = oldLostHearts - state.getLostHearts();
        this.applyMaxHealth(player, state);
        player.method_6033(state.getMaxHealth());
        return restored;
    }

    private final boolean isInPurgatoryDimension(class_3222 player) {
        class_5321 class_53212 = player.method_51469().method_27983();
        Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"dimension(...)");
        class_5321 dimensionKey = class_53212;
        return Intrinsics.areEqual((Object)dimensionKey, DimensionManager.INSTANCE.getPURGATORY_DIMENSION_KEY());
    }

    public final void onParkourComplete(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        logger.info("Player " + player.method_7334().name() + " completed the parkour!");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerStateManager.INSTANCE.completeParkour(uUID);
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7lParkour completed!"));
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eWaiting for your teammates to craft the revive item..."));
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        this.checkAndCompleteRevive(uUID2, server);
        NetworkHandler.INSTANCE.sendStatusUpdate(player);
    }

    public final void onReviveItemCrafted(@NotNull UUID deadPlayerUuid, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)deadPlayerUuid, (String)"deadPlayerUuid");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        ReviveTask task = PlayerStateManager.INSTANCE.getReviveTask(deadPlayerUuid);
        if (task != null) {
            task.markCraftingComplete();
            logger.info("Revive item crafted for player " + deadPlayerUuid);
            this.checkAndCompleteRevive(deadPlayerUuid, server);
        }
    }

    private final void checkAndCompleteRevive(UUID deadPlayerUuid, MinecraftServer server) {
        class_3222 player;
        boolean success;
        ReviveTask reviveTask = PlayerStateManager.INSTANCE.getReviveTask(deadPlayerUuid);
        if (reviveTask == null) {
            return;
        }
        ReviveTask task = reviveTask;
        if (task.isComplete() && (success = PlayerStateManager.INSTANCE.completeRevive(deadPlayerUuid)) && (player = server.method_3760().method_14602(deadPlayerUuid)) != null) {
            this.revivePlayer(player);
        }
    }

    private final void revivePlayer(class_3222 player) {
        logger.info("Reviving player " + player.method_7334().name() + "!");
        PlayerStateData state = PlayerStateManager.INSTANCE.getPlayerState(player);
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7lYou have been revived!"));
        this.applyMaxHealth(player, state);
        player.method_6033(state.getMaxHealth());
        player.method_7344().method_7580(20);
        player.method_7344().method_7581(5.0f);
        player.method_5646();
        player.method_7336(class_1934.field_9215);
        DimensionManager.INSTANCE.teleportToOverworld(player);
        this.grantSpawnProtection(player);
        if (state.getLostHearts() > 0) {
            int heartsRemaining = 10 - state.getLostHearts();
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7eYour permanent hearts: \u00a7c" + heartsRemaining + "\u00a7e/10")));
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        class_2338 gravePos = GraveManager.INSTANCE.getGraveLocation(uUID);
        if (gravePos != null) {
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            if (GraveManager.INSTANCE.hasStoredItems(uUID2)) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Your items are waiting at your grave!"));
                player.method_64398((class_2561)class_2561.method_43470((String)("\u00a77Location: X=" + gravePos.method_10263() + ", Y=" + (gravePos.method_10264() - 1) + ", Z=" + gravePos.method_10260())));
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Click on your grave to retrieve your items."));
            }
        }
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        for (Object e : server.method_3760().method_14571()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            class_3222 p = (class_3222)e;
            p.method_64398((class_2561)class_2561.method_43470((String)("\u00a7a" + player.method_7334().name() + " has been revived!")));
        }
        NetworkHandler.INSTANCE.sendStatusUpdate(player);
        NetworkHandler.INSTANCE.broadcastStatusUpdates(server);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerStatus.values().length];
            try {
                nArray[PlayerStatus.IN_PURGATORY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerStatus.SPECTATOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerStatus.ALIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

