/*
 * Decompiled with CFR 0.152.
 */
package revive.mod;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b \b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\tJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0010J\r\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0010J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0003R\"\u0010\u0015\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u0016\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u0019R\"\u0010\u001d\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010!R\"\u0010\"\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u001e\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010!R\"\u0010%\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u001e\u001a\u0004\b&\u0010\u0010\"\u0004\b'\u0010!R\"\u0010(\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010\u001e\u001a\u0004\b)\u0010\u0010\"\u0004\b*\u0010!R\"\u0010+\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010\u0006\"\u0004\b.\u0010/R\"\u00100\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010,\u001a\u0004\b1\u0010\u0006\"\u0004\b2\u0010/\u00a8\u00063"}, d2={"Lrevive/mod/ClientPlayerState;", "", "<init>", "()V", "", "getElapsedTimeMs", "()J", "", "getFormattedTime", "()Ljava/lang/String;", "getStatusText", "", "getStatusColor", "()I", "", "isInPurgatory", "()Z", "isSpectator", "isAlive", "", "reset", "status", "I", "getStatus", "setStatus", "(I)V", "deathCount", "getDeathCount", "setDeathCount", "parkourCompleted", "Z", "getParkourCompleted", "setParkourCompleted", "(Z)V", "craftingCompleted", "getCraftingCompleted", "setCraftingCompleted", "gameActive", "getGameActive", "setGameActive", "gamePaused", "getGamePaused", "setGamePaused", "serverElapsedTimeMs", "J", "getServerElapsedTimeMs", "setServerElapsedTimeMs", "(J)V", "lastSyncTime", "getLastSyncTime", "setLastSyncTime", "hardcore-mod_client"})
@Environment(value=EnvType.CLIENT)
public final class ClientPlayerState {
    @NotNull
    public static final ClientPlayerState INSTANCE = new ClientPlayerState();
    private static int status;
    private static int deathCount;
    private static boolean parkourCompleted;
    private static boolean craftingCompleted;
    private static boolean gameActive;
    private static boolean gamePaused;
    private static long serverElapsedTimeMs;
    private static long lastSyncTime;

    private ClientPlayerState() {
    }

    public final int getStatus() {
        return status;
    }

    public final void setStatus(int n) {
        status = n;
    }

    public final int getDeathCount() {
        return deathCount;
    }

    public final void setDeathCount(int n) {
        deathCount = n;
    }

    public final boolean getParkourCompleted() {
        return parkourCompleted;
    }

    public final void setParkourCompleted(boolean bl) {
        parkourCompleted = bl;
    }

    public final boolean getCraftingCompleted() {
        return craftingCompleted;
    }

    public final void setCraftingCompleted(boolean bl) {
        craftingCompleted = bl;
    }

    public final boolean getGameActive() {
        return gameActive;
    }

    public final void setGameActive(boolean bl) {
        gameActive = bl;
    }

    public final boolean getGamePaused() {
        return gamePaused;
    }

    public final void setGamePaused(boolean bl) {
        gamePaused = bl;
    }

    public final long getServerElapsedTimeMs() {
        return serverElapsedTimeMs;
    }

    public final void setServerElapsedTimeMs(long l) {
        serverElapsedTimeMs = l;
    }

    public final long getLastSyncTime() {
        return lastSyncTime;
    }

    public final void setLastSyncTime(long l) {
        lastSyncTime = l;
    }

    public final long getElapsedTimeMs() {
        if (!gameActive || gamePaused) {
            return serverElapsedTimeMs;
        }
        long timeSinceSync = System.currentTimeMillis() - lastSyncTime;
        return serverElapsedTimeMs + timeSinceSync;
    }

    @NotNull
    public final String getFormattedTime() {
        long totalSeconds = this.getElapsedTimeMs() / (long)1000;
        long hours = totalSeconds / (long)3600;
        long minutes = totalSeconds % (long)3600 / (long)60;
        long seconds = totalSeconds % (long)60;
        String string = "%02d:%02d:%02d";
        Object[] objectArray = new Object[]{hours, minutes, seconds};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String getStatusText() {
        return switch (status) {
            case 0 -> "Alive";
            case 1 -> "In Purgatory";
            case 2 -> "Spectator";
            default -> "Unknown";
        };
    }

    public final int getStatusColor() {
        return switch (status) {
            case 0 -> 0x55FF55;
            case 1 -> 0xFFAA00;
            case 2 -> 0xFF5555;
            default -> 0xFFFFFF;
        };
    }

    public final boolean isInPurgatory() {
        return status == 1;
    }

    public final boolean isSpectator() {
        return status == 2;
    }

    public final boolean isAlive() {
        return status == 0;
    }

    public final void reset() {
        status = 0;
        deathCount = 0;
        parkourCompleted = false;
        craftingCompleted = false;
        gameActive = false;
        gamePaused = false;
        serverElapsedTimeMs = 0L;
        lastSyncTime = 0L;
    }
}

